"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCurrentDocTitle = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCurrentDocTitle = page => {
  let updatedTitle;
  switch (page) {
    case 'logs':
      updatedTitle = _i18n.i18n.translate('xpack.triggersActionsUI.logs.breadcrumbTitle', {
        defaultMessage: 'Logs'
      });
      break;
    case 'connectors':
      updatedTitle = _i18n.i18n.translate('xpack.triggersActionsUI.connectors.breadcrumbTitle', {
        defaultMessage: 'Connectors'
      });
      break;
    case 'rules':
      updatedTitle = _i18n.i18n.translate('xpack.triggersActionsUI.rules.breadcrumbTitle', {
        defaultMessage: 'Rules'
      });
      break;
    case 'createRule':
      updatedTitle = _i18n.i18n.translate('xpack.triggersActionsUI.rules.createRule.breadcrumbTitle', {
        defaultMessage: 'Create rule'
      });
      break;
    case 'editRule':
      updatedTitle = _i18n.i18n.translate('xpack.triggersActionsUI.rules.editRule.breadcrumbTitle', {
        defaultMessage: 'Edit rule'
      });
      break;
    case 'alerts':
      updatedTitle = _i18n.i18n.translate('xpack.triggersActionsUI.alerts.breadcrumbTitle', {
        defaultMessage: 'Alerts'
      });
      break;
    default:
      updatedTitle = _i18n.i18n.translate('xpack.triggersActionsUI.home.breadcrumbTitle', {
        defaultMessage: 'Rules'
      });
  }
  return updatedTitle;
};
exports.getCurrentDocTitle = getCurrentDocTitle;