"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formSerializer = exports.formDeserializer = exports.ConnectorForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _eui = require("@elastic/eui");
var _connector_form_fields = require("./connector_form_fields");
var _encrypted_fields_callout = require("./encrypted_fields_callout");
var _connector_overrides = require("./connector_overrides");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/action_connector_form/connector_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * The serializer and deserializer are needed to transform the headers of
 * the webhook connectors. The webhook connector uses the UseArray component
 * to add dynamic headers to the form. The UseArray component formats the fields
 * as an array of objects. The schema for the headers of the webhook connector
 * is Record<string, string>. We need to transform the UseArray format to the one
 * accepted by the backend. At the moment, the UseArray does not accepts
 * a serializer and deserializer so it has to be done on the form level. When issue #133107
 * is resolved we should move the serializer and deserializer functions to the
 * webhook connector.
 */

// TODO: Remove when https://github.com/elastic/kibana/issues/133107 is resolved
const formDeserializer = data => {
  var _data$config$headers;
  const overrides = (0, _connector_overrides.connectorOverrides)(data.actionTypeId);
  if (overrides !== null && overrides !== void 0 && overrides.formDeserializer) {
    return overrides.formDeserializer(data);
  }
  if (data.actionTypeId !== '.webhook' && data.actionTypeId !== '.cases-webhook' && data.actionTypeId !== '.gen-ai') {
    return data;
  }
  const configHeaders = Object.entries((_data$config$headers = data === null || data === void 0 ? void 0 : data.config.headers) !== null && _data$config$headers !== void 0 ? _data$config$headers : {}).map(([key, value]) => ({
    key,
    value,
    type: 'config'
  }));
  return {
    ...data,
    config: {
      ...data.config,
      headers: (0, _lodash.isEmpty)(configHeaders) ? undefined : configHeaders
    },
    __internal__: {
      headers: configHeaders
    }
  };
};
exports.formDeserializer = formDeserializer;
const buildHeaderRecords = (headers, type) => {
  return headers.filter(header => header.type === type && header.key && header.key.trim()).reduce((acc, {
    key,
    value
  }) => {
    acc[key] = value;
    return acc;
  }, {});
};

// TODO: Remove when https://github.com/elastic/kibana/issues/133107 is resolved
const formSerializer = formData => {
  const overrides = (0, _connector_overrides.connectorOverrides)(formData.actionTypeId);
  if (overrides !== null && overrides !== void 0 && overrides.formSerializer) {
    return overrides.formSerializer(formData);
  }
  if (formData.actionTypeId !== '.webhook' && formData.actionTypeId !== '.cases-webhook' && formData.actionTypeId !== '.gen-ai') {
    return formData;
  }
  let configHeaders;
  let secretHeaders;
  if (formData.actionTypeId === '.gen-ai') {
    var _webhookFormData$conf, _webhookFormData$conf2;
    const webhookFormData = formData;
    secretHeaders = {};
    configHeaders = ((_webhookFormData$conf = webhookFormData === null || webhookFormData === void 0 ? void 0 : (_webhookFormData$conf2 = webhookFormData.config) === null || _webhookFormData$conf2 === void 0 ? void 0 : _webhookFormData$conf2.headers) !== null && _webhookFormData$conf !== void 0 ? _webhookFormData$conf : []).reduce((acc, header) => ({
      ...acc,
      [header.key]: header.value
    }), {});
  } else {
    var _formData$__internal_, _formData$__internal_2;
    const headers = (_formData$__internal_ = formData === null || formData === void 0 ? void 0 : (_formData$__internal_2 = formData.__internal__) === null || _formData$__internal_2 === void 0 ? void 0 : _formData$__internal_2.headers) !== null && _formData$__internal_ !== void 0 ? _formData$__internal_ : [];
    configHeaders = buildHeaderRecords(headers, 'config');
    secretHeaders = buildHeaderRecords(headers, 'secret');
  }
  return {
    ...formData,
    config: {
      ...formData.config,
      headers: (0, _lodash.isEmpty)(configHeaders) ? formData.actionTypeId !== '.gen-ai' ? null : undefined : configHeaders
    },
    secrets: {
      ...formData.secrets,
      secretHeaders: (0, _lodash.isEmpty)(secretHeaders) ? undefined : secretHeaders
    }
  };
};
exports.formSerializer = formSerializer;
const ConnectorFormComponent = ({
  actionTypeModel,
  connector,
  isEdit,
  onChange,
  onFormModifiedChange,
  setResetForm
}) => {
  const {
    form
  } = (0, _hook_form_lib.useForm)({
    defaultValue: connector,
    serializer: formSerializer,
    deserializer: formDeserializer
  });
  const {
    submit,
    isValid: isFormValid,
    isSubmitted,
    isSubmitting,
    reset
  } = form;
  const [preSubmitValidator, setPreSubmitValidator] = (0, _react.useState)(null);
  const registerPreSubmitValidator = (0, _react.useCallback)(validator => {
    setPreSubmitValidator(() => validator);
  }, []);
  const isFormModified = (0, _hook_form_lib.useFormIsModified)({
    form,
    discard: ['__internal__', '__internal__.headers__array__']
  });
  (0, _react.useEffect)(() => {
    if (onChange) {
      onChange({
        isValid: isFormValid,
        isSubmitted,
        isSubmitting,
        submit,
        preSubmitValidator
      });
    }
  }, [onChange, isFormValid, isSubmitted, isSubmitting, submit, preSubmitValidator]);
  (0, _react.useEffect)(() => {
    if (onFormModifiedChange) {
      onFormModifiedChange(isFormModified);
    }
  }, [isFormModified, onFormModifiedChange]);
  (0, _react.useEffect)(() => {
    if (setResetForm) {
      setResetForm(reset);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [reset]);
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.Form, {
    form: form,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_connector_form_fields.ConnectorFormFields, {
    actionTypeModel: actionTypeModel,
    isEdit: isEdit,
    registerPreSubmitValidator: registerPreSubmitValidator,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_encrypted_fields_callout.EncryptedFieldsCallout, {
    isEdit: isEdit,
    isMissingSecrets: connector.isMissingSecrets,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 7
    }
  }));
};
const ConnectorForm = exports.ConnectorForm = /*#__PURE__*/_react.default.memo(ConnectorFormComponent);