"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorsSelection = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _connectors = require("../common/connectors");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/action_connector_form/connectors_selection.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConnectorsSelection = exports.ConnectorsSelection = /*#__PURE__*/_react.default.memo(ConnectorsSelectionComponent);
function ConnectorsSelectionComponent({
  allowGroupConnector,
  actionItem,
  accordionIndex,
  actionTypesIndex,
  actionTypeRegistered,
  connectors,
  onConnectorSelected
}) {
  var _selectedOption$value;
  const validConnectors = (0, _react.useMemo)(() => (0, _connectors.getValidConnectors)(connectors, actionItem, actionTypesIndex, allowGroupConnector), [actionItem, actionTypesIndex, allowGroupConnector, connectors]);
  const selectedConnectors = (0, _react.useMemo)(() => getValueOfSelectedConnector(actionItem.id, validConnectors, actionTypeRegistered, allowGroupConnector), [actionItem.id, validConnectors, actionTypeRegistered, allowGroupConnector]);
  const options = (0, _react.useMemo)(() => createConnectorOptions(validConnectors, actionTypeRegistered), [validConnectors, actionTypeRegistered]);
  const [selectedOption, setSelectedOption] = (0, _react.useState)(selectedConnectors.length > 0 ? selectedConnectors[0] : undefined);
  const onChange = (0, _react.useCallback)(connectorOptions => {
    var _connectorOptions$0$v, _connectorOptions$0$v2;
    setSelectedOption(connectorOptions[0]);
    onConnectorSelected((_connectorOptions$0$v = (_connectorOptions$0$v2 = connectorOptions[0].value) === null || _connectorOptions$0$v2 === void 0 ? void 0 : _connectorOptions$0$v2.id) !== null && _connectorOptions$0$v !== void 0 ? _connectorOptions$0$v : '');
  }, [onConnectorSelected]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "aria-label": incidentManagemSystem,
    "data-test-subj": `selectActionConnector-${actionItem.actionTypeId}-${accordionIndex}`,
    fullWidth: true,
    singleSelection: {
      asPlainText: true
    },
    id: `selectActionConnector-${actionItem.id}`,
    isClearable: false,
    onChange: onChange,
    options: options,
    selectedOptions: selectedConnectors,
    prepend: selectedOption === null || selectedOption === void 0 ? void 0 : (_selectedOption$value = selectedOption.value) === null || _selectedOption$value === void 0 ? void 0 : _selectedOption$value.prependComponent,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 5
    }
  });
}
const getValueOfSelectedConnector = (actionItemId, connectors, actionTypeRegistered, allowGroupConnector = []) => {
  const selectedConnector = connectors.find(connector => connector.id === actionItemId);
  if (!selectedConnector) {
    return [];
  }
  return [createOption(selectedConnector, actionTypeRegistered)];
};
const createConnectorOptions = (connectors, actionTypeRegistered) => connectors.map(connector => createOption(connector, actionTypeRegistered));
const createOption = (connector, actionTypeRegistered) => {
  const title = getTitle(connector, actionTypeRegistered);
  let prependComponent;
  if (actionTypeRegistered.customConnectorSelectItem != null) {
    const CustomPrependComponent = actionTypeRegistered.customConnectorSelectItem.getComponent(connector);
    if (CustomPrependComponent) {
      prependComponent = /*#__PURE__*/_react.default.createElement(CustomPrependComponent, {
        actionConnector: connector,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 127,
          columnNumber: 26
        }
      });
    }
  }
  return {
    label: title,
    value: {
      title,
      id: connector.id,
      prependComponent
    },
    key: connector.id,
    'data-test-subj': `dropdown-connector-${connector.id}`
  };
};
const getTitle = (connector, actionTypeRegistered) => {
  if (actionTypeRegistered.customConnectorSelectItem != null) {
    return actionTypeRegistered.customConnectorSelectItem.getText(connector);
  }
  return connector.name;
};
const incidentManagemSystem = _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionForm.incidentManagementSystemLabel', {
  defaultMessage: 'Incident management system'
});