"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SystemActionTypeForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _lodash = require("lodash");
var _alertsUiShared = require("@kbn/alerts-ui-shared");
var _translations = require("../translations");
var _types = require("../../../types");
var _kibana = require("../../../common/lib/kibana");
var _validate_params_for_warnings = require("../../lib/validate_params_for_warnings");
var _use_rule_alert_fields = require("../../hooks/use_rule_alert_fields");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/action_connector_form/system_action_type_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SystemActionTypeForm = ({
  actionItem,
  actionConnector,
  index,
  onDeleteAction,
  setActionParamsProperty,
  actionTypesIndex,
  connectors,
  defaultActionMessage,
  messageVariables,
  summaryMessageVariables,
  actionTypeRegistry,
  defaultSummaryMessage,
  producerId,
  featureId,
  ruleTypeId,
  disableErrorMessages
}) => {
  var _actionTypeRegistered;
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const [isOpen, setIsOpen] = (0, _react.useState)(true);
  const [actionParamsErrors, setActionParamsErrors] = (0, _react.useState)({
    errors: {}
  });
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const actAccordionActionFormCss = (0, _react2.css)`
    .actAccordionActionForm {
      background-color: ${euiTheme.colors.lightestShade};

      .euiCard {
        box-shador: none;
      }
      .actAccordionActionForm__button {
        padding: ${euiTheme.size.m};
        padding-left: ${euiTheme.size.l};
      }

      .euiAccordion__arrow {
        transform: translateX(${euiTheme.size.m}) rotate(0deg) !important;
      }

      .euiAccordion__arrow[aria-expanded='true'] {
        transform: translateX(${euiTheme.size.m}) rotate(90deg) !important;
      }
    }
  `;
  const [warning, setWarning] = (0, _react.useState)(null);
  const {
    fields: alertFields
  } = (0, _use_rule_alert_fields.useRuleTypeAlertFields)(http, ruleTypeId, true);
  const getDefaultParams = (0, _react.useCallback)(() => {
    const connectorType = actionTypeRegistry.get(actionItem.actionTypeId);
    return connectorType.defaultActionParams;
  }, [actionItem.actionTypeId, actionTypeRegistry]);
  const availableActionVariables = (0, _react.useMemo)(() => messageVariables ? getAvailableActionVariables(messageVariables, summaryMessageVariables, undefined, true) : [], [messageVariables, summaryMessageVariables]);
  (0, _react.useEffect)(() => {
    const defaultParams = getDefaultParams();
    if (defaultParams) {
      for (const [key, paramValue] of Object.entries(defaultParams)) {
        const defaultAADParams = {};
        if (actionItem.params[key] === undefined || actionItem.params[key] === null) {
          setActionParamsProperty(key, paramValue, index);
          // Add default param to AAD defaults only if it does not contain any template code
          if (typeof paramValue !== 'string' || !paramValue.match(/{{.*?}}/g)) {
            defaultAADParams[key] = paramValue;
          }
        }
      }
    }
  }, [actionItem.params, getDefaultParams, index, messageVariables, setActionParamsProperty, summaryMessageVariables]);
  (0, _react.useEffect)(() => {
    const defaultParams = getDefaultParams();
    if (defaultParams) {
      const defaultAADParams = {};
      for (const [key, paramValue] of Object.entries(defaultParams)) {
        setActionParamsProperty(key, paramValue, index);
        if (!paramValue.match(/{{.*?}}/g)) {
          defaultAADParams[key] = paramValue;
        }
      }
    }
  }, [getDefaultParams, index, setActionParamsProperty]);
  (0, _react.useEffect)(() => {
    (async _actionTypeRegistry$g => {
      if (disableErrorMessages) {
        setActionParamsErrors({
          errors: {}
        });
        return;
      }
      const res = await ((_actionTypeRegistry$g = actionTypeRegistry.get(actionItem.actionTypeId)) === null || _actionTypeRegistry$g === void 0 ? void 0 : _actionTypeRegistry$g.validateParams(actionItem.params));
      setActionParamsErrors(res);
    })();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [actionItem, disableErrorMessages]);
  const actionTypeRegistered = actionTypeRegistry.get(actionConnector.actionTypeId);
  if (!actionTypeRegistered) return null;
  const showActionGroupErrorIcon = () => {
    return !isOpen && (0, _lodash.some)(actionParamsErrors.errors, error => !(0, _lodash.isEmpty)(error));
  };
  const ParamsFieldsComponent = actionTypeRegistered.actionParamsFields;
  const checkEnabledResult = (0, _alertsUiShared.checkActionFormActionTypeEnabled)(actionTypesIndex[actionConnector.actionTypeId], []);
  const accordionContent = checkEnabledResult.isEnabled ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    color: "plain",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 7
    }
  }, ParamsFieldsComponent ? /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: null,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(ParamsFieldsComponent, {
    actionParams: actionItem.params,
    errors: actionParamsErrors.errors,
    index: index,
    editAction: (key, value, i) => {
      setWarning((0, _validate_params_for_warnings.validateParamsForWarnings)(value, http.basePath.publicBaseUrl, availableActionVariables));
      setActionParamsProperty(key, value, i);
    },
    messageVariables: alertFields,
    defaultMessage: defaultSummaryMessage,
    useDefaultMessage: true,
    actionConnector: actionConnector,
    executionMode: _types.ActionConnectorMode.ActionForm,
    ruleTypeId: ruleTypeId,
    producerId: producerId,
    featureId: featureId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 19
    }
  }), warning ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 23
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    color: "warning",
    title: warning,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 23
    }
  })) : null)))) : null)) : checkEnabledResult.messageCard;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    hasShadow: isOpen,
    css: actAccordionActionFormCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    initialIsOpen: true,
    key: index,
    id: index.toString(),
    onToggle: setIsOpen,
    paddingSize: "none",
    className: "actAccordionActionForm",
    buttonContentClassName: "actAccordionActionForm__button",
    "data-test-subj": `alertActionAccordion-${index}`,
    buttonContent: /*#__PURE__*/_react.default.createElement(ButtonContent, {
      showActionGroupErrorIcon: showActionGroupErrorIcon(),
      showWarning: Boolean(warning && !isOpen),
      connectorName: actionConnector.name,
      isExperimental: Boolean(actionTypeRegistered && actionTypeRegistered.isExperimental),
      iconClass: (_actionTypeRegistered = actionTypeRegistered.iconClass) !== null && _actionTypeRegistered !== void 0 ? _actionTypeRegistered : 'empty',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 262,
        columnNumber: 13
      }
    }),
    extraAction: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "minusInCircle",
      color: "danger",
      className: "actAccordionActionForm__extraAction",
      "aria-label": _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionTypeForm.accordion.deleteIconAriaLabel', {
        defaultMessage: 'Delete'
      }),
      onClick: onDeleteAction,
      "data-test-subj": "system-action-delete-button",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 271,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 9
    }
  }, accordionContent)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 289,
      columnNumber: 7
    }
  }));
};
exports.SystemActionTypeForm = SystemActionTypeForm;
function getAvailableActionVariables(actionVariables, summaryActionVariables, actionGroup, isSummaryAction) {
  const transformedActionVariables = (0, _alertsUiShared.transformActionVariables)(actionVariables, summaryActionVariables, actionGroup === null || actionGroup === void 0 ? void 0 : actionGroup.omitMessageVariables, isSummaryAction);

  // partition deprecated items so they show up last
  const partitionedActionVariables = (0, _lodash.partition)(transformedActionVariables, v => v.deprecated !== true);
  return partitionedActionVariables.reduce((acc, curr) => {
    return [...acc, ...curr.sort((a, b) => a.name.toUpperCase().localeCompare(b.name.toUpperCase()))];
  }, []);
}
const ButtonContent = ({
  showActionGroupErrorIcon,
  iconClass,
  showWarning,
  isExperimental,
  connectorName
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 328,
      columnNumber: 5
    }
  }, showActionGroupErrorIcon ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 330,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionTypeForm.actionErrorToolTip', {
      defaultMessage: 'Action contains errors.'
    }),
    type: "warning",
    color: "danger",
    size: "m",
    iconProps: {
      'data-test-subj': 'action-group-error-icon'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 331,
      columnNumber: 11
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 345,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: iconClass,
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 346,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 349,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 350,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 351,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 352,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 353,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "{actionConnectorName}",
    id: "xpack.triggersActionsUI.sections.actionTypeForm.existingAlertActionTypeEditTitle",
    values: {
      actionConnectorName: `${connectorName}`
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 354,
      columnNumber: 17
    }
  })), showWarning && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 363,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    "data-test-subj": "warning-badge",
    iconType: "warning",
    color: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 364,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionTypeForm.actionWarningsTitle', {
    defaultMessage: '1 warning'
  }))))))), isExperimental && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 379,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    "data-test-subj": "action-type-form-beta-badge",
    label: _translations.TECH_PREVIEW_LABEL,
    tooltipContent: _translations.TECH_PREVIEW_DESCRIPTION,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 380,
      columnNumber: 11
    }
  })));
};