"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.ActionsConnectorsHome = void 0;
var _react = _interopRequireWildcard(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _reactRouterDom = require("react-router-dom");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _constants = require("../../../constants");
var _breadcrumb = require("../../../lib/breadcrumb");
var _doc_title = require("../../../lib/doc_title");
var _suspended_component_with_props = require("../../../lib/suspended_component_with_props");
var _health_context = require("../../../context/health_context");
var _health_check = require("../../../components/health_check");
var _kibana = require("../../../../common/lib/kibana");
var _actions_connectors_event_log_list_table = _interopRequireDefault(require("./actions_connectors_event_log_list_table"));
var _types = require("../../../../types");
var _create_connector_flyout = require("../../action_connector_form/create_connector_flyout");
var _edit_connector_flyout = require("../../action_connector_form/edit_connector_flyout");
var _action_connector_api = require("../../../lib/action_connector_api");
var _capabilities = require("../../../lib/capabilities");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/actions_connectors_list/components/actions_connectors_home.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConnectorsList = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./actions_connectors_list'))));
const ActionsConnectorsHome = ({
  match: {
    params: {
      section
    }
  },
  history
}) => {
  const {
    chrome,
    setBreadcrumbs,
    docLinks,
    actionTypeRegistry,
    http,
    notifications: {
      toasts
    },
    application: {
      capabilities
    }
  } = (0, _kibana.useKibana)().services;
  const location = (0, _reactRouterDom.useLocation)();
  const [addFlyoutVisible, setAddFlyoutVisibility] = (0, _react.useState)(false);
  const [editConnectorProps, setEditConnectorProps] = (0, _react.useState)({});
  const [actions, setActions] = (0, _react.useState)([]);
  const [isLoadingActions, setIsLoadingActions] = (0, _react.useState)(true);
  const editItem = (0, _react.useCallback)((actionConnector, tab, isFix) => {
    setEditConnectorProps({
      initialConnector: actionConnector,
      tab,
      isFix: isFix !== null && isFix !== void 0 ? isFix : false
    });
  }, [setEditConnectorProps]);
  const loadActions = (0, _react.useCallback)(async () => {
    setIsLoadingActions(true);
    try {
      const actionsResponse = await (0, _action_connector_api.loadAllActions)({
        http
      });
      setActions(actionsResponse);
    } catch (e) {
      toasts.addDanger({
        title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.connector.home.unableToLoadActionsMessage', {
          defaultMessage: 'Unable to load connectors'
        })
      });
    } finally {
      setIsLoadingActions(false);
    }
  }, [http, toasts]);
  (0, _react.useEffect)(() => {
    loadActions();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const tabs = [];
  tabs.push({
    id: 'connectors',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.connectors.home.connectorsTabTitle",
      defaultMessage: "Connectors",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 7
      }
    })
  });
  tabs.push({
    id: 'logs',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.connectors.home.logsTabTitle",
      defaultMessage: "Logs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 7
      }
    })
  });
  const onSectionChange = newSection => {
    history.push(`/${newSection}`);
  };

  // Set breadcrumb and page title
  (0, _react.useEffect)(() => {
    setBreadcrumbs([(0, _breadcrumb.getAlertingSectionBreadcrumb)(section || 'connectors')]);
    chrome.docTitle.change((0, _doc_title.getCurrentDocTitle)(section || 'connectors'));
  }, [section, chrome, setBreadcrumbs]);
  const renderLogsList = (0, _react.useCallback)(() => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
      grow: false,
      paddingSize: "none",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 7
      }
    }, (0, _suspended_component_with_props.suspendedComponentWithProps)(_actions_connectors_event_log_list_table.default, 'xl')({
      refreshToken: 0,
      initialPageSize: 50,
      hasConnectorNames: true,
      hasAllSpaceSwitch: true
    }));
  }, []);
  const renderConnectorsList = () => {
    return (0, _suspended_component_with_props.suspendedComponentWithProps)(ConnectorsList, 'xl')({
      setAddFlyoutVisibility,
      editItem,
      isLoadingActions,
      actions,
      loadActions,
      setActions
    });
  };
  const createConnectorButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "createConnectorButton",
    fill: true,
    iconType: "plusInCircle",
    iconSide: "left",
    onClick: () => setAddFlyoutVisibility(true),
    isLoading: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.triggersActionsUI.connectors.home.createConnector', {
    defaultMessage: 'Create connector'
  }));
  const documentationButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "documentationButton",
    key: "documentation-button",
    target: "_blank",
    href: docLinks.links.alerting.actionTypes,
    iconType: "question",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.connectors.home.documentationButtonLabel",
    defaultMessage: "Documentation",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 7
    }
  }));
  let topRightSideButtons = [];
  if ((0, _reactRouterDom.matchPath)(location.pathname, {
    path: _constants.routeToConnectors,
    exact: true
  }) || (0, _reactRouterDom.matchPath)(location.pathname, {
    path: _constants.routeToConnectorEdit,
    exact: true
  })) {
    topRightSideButtons = [];
    const canSave = (0, _capabilities.hasSaveActionsCapability)(capabilities);
    if (canSave) {
      topRightSideButtons.push(createConnectorButton);
    }
    topRightSideButtons.push(documentationButton);
  } else if ((0, _reactRouterDom.matchPath)(location.pathname, {
    path: _constants.routeToLogs,
    exact: true
  })) {
    topRightSideButtons = [documentationButton];
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    bottomBorder: true,
    paddingSize: "none",
    pageTitle: _i18n.i18n.translate('xpack.triggersActionsUI.connectors.home.appTitle', {
      defaultMessage: 'Connectors'
    }),
    description: _i18n.i18n.translate('xpack.triggersActionsUI.connectors.home.description', {
      defaultMessage: 'Connect third-party software with your alerting data.'
    }),
    rightSideItems: topRightSideButtons,
    tabs: tabs.map(tab => ({
      label: tab.name,
      onClick: () => onSectionChange(tab.id),
      isSelected: tab.id === section,
      key: tab.id,
      'data-test-subj': `${tab.id}Tab`
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 7
    }
  }), addFlyoutVisible && /*#__PURE__*/_react.default.createElement(_create_connector_flyout.CreateConnectorFlyout, {
    onClose: () => {
      setAddFlyoutVisibility(false);
    },
    onTestConnector: connector => editItem(connector, _types.EditConnectorTabs.Test),
    onConnectorCreated: loadActions,
    actionTypeRegistry: actionTypeRegistry,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 9
    }
  }), editConnectorProps.initialConnector && /*#__PURE__*/_react.default.createElement(_edit_connector_flyout.EditConnectorFlyout, {
    key: `${editConnectorProps.initialConnector.id}${editConnectorProps.tab ? `:${editConnectorProps.tab}` : ``}`,
    connector: editConnectorProps.initialConnector,
    tab: editConnectorProps.tab,
    onClose: () => {
      setEditConnectorProps({
        tab: editConnectorProps === null || editConnectorProps === void 0 ? void 0 : editConnectorProps.tab,
        isFix: editConnectorProps === null || editConnectorProps === void 0 ? void 0 : editConnectorProps.isFix
      });
    },
    onConnectorUpdated: connector => {
      setEditConnectorProps({
        ...editConnectorProps,
        initialConnector: connector
      });
      loadActions();
    },
    actionTypeRegistry: actionTypeRegistry,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_health_context.HealthContextProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_health_check.HealthCheck, {
    waitForCheck: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 259,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _constants.routeToLogs,
    component: renderLogsList,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: [_constants.routeToConnectors, _constants.routeToConnectorEdit],
    render: renderConnectorsList,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 13
    }
  })))));
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.ActionsConnectorsHome = ActionsConnectorsHome;