"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _reactRouterDom = require("react-router-dom");
var _common = require("@kbn/actions-plugin/common");
var _i18nReact = require("@kbn/i18n-react");
var _check_action_type_enabled = require("@kbn/alerts-ui-shared/src/check_action_type_enabled");
var _action_connector_api = require("../../../lib/action_connector_api");
var _capabilities = require("../../../lib/capabilities");
var _delete_modal_confirmation = require("../../../components/delete_modal_confirmation");
var _types = require("../../../../types");
var _empty_connectors_prompt = require("../../../components/prompts/empty_connectors_prompt");
var _kibana = require("../../../../common/lib/kibana");
var _center_justified_spinner = require("../../../components/center_justified_spinner");
var _connectors_selection = require("../../../../common/connectors_selection");
var _breadcrumb = require("../../../lib/breadcrumb");
var _doc_title = require("../../../lib/doc_title");
var _constants = require("../../../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/actions_connectors_list/components/actions_connectors_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConnectorIconTipWithSpacing = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    "aria-label": "Warning",
    size: "m",
    type: "warning",
    color: "warning",
    content: _connectors_selection.connectorDeprecatedMessage,
    position: "right",
    iconProps: {
      style: {
        verticalAlign: 'text-top'
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 5
    }
  });
};
const ActionsConnectorsList = ({
  setAddFlyoutVisibility,
  editItem,
  isLoadingActions,
  actions,
  loadActions,
  setActions
}) => {
  const {
    http,
    notifications: {
      toasts
    },
    application: {
      capabilities
    },
    setBreadcrumbs,
    chrome,
    docLinks
  } = (0, _kibana.useKibana)().services;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    connectorId
  } = (0, _reactRouterDom.useParams)();
  const history = (0, _reactRouterDom.useHistory)();
  const location = (0, _reactRouterDom.useLocation)();
  const canDelete = (0, _capabilities.hasDeleteActionsCapability)(capabilities);
  const canSave = (0, _capabilities.hasSaveActionsCapability)(capabilities);
  const [actionTypesIndex, setActionTypesIndex] = (0, _react.useState)(undefined);
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const [selectedItems, setSelectedItems] = (0, _react.useState)([]);
  const [isLoadingActionTypes, setIsLoadingActionTypes] = (0, _react.useState)(false);
  const [connectorsToDelete, setConnectorsToDelete] = (0, _react.useState)([]);
  const [showWarningText, setShowWarningText] = (0, _react.useState)(false);
  const disabledActConnectorCss = (0, _react2.css)`
    .actConnectorsList__tableRowDisabled {
      background-color: ${euiTheme.colors.lightestShade};

      .actConnectorsList__tableCellDisabled {
        color: ${euiTheme.colors.darkShade};
      }
      .euiLink + .euiToolTipAnchor {
        margin-left: ${euiTheme.size.xs};
      }
    }
  `;

  // Set breadcrumb and page title
  (0, _react.useEffect)(() => {
    setBreadcrumbs([(0, _breadcrumb.getAlertingSectionBreadcrumb)('connectors')]);
    chrome.docTitle.change((0, _doc_title.getCurrentDocTitle)('connectors'));
  }, [chrome, setBreadcrumbs]);
  (0, _react.useEffect)(() => {
    (async () => {
      try {
        setIsLoadingActionTypes(true);
        const actionTypes = await (0, _action_connector_api.loadActionTypes)({
          http
        });
        const index = {};
        for (const actionTypeItem of actionTypes) {
          index[actionTypeItem.id] = actionTypeItem;
        }
        setActionTypesIndex(index);
      } catch (e) {
        toasts.addDanger({
          title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionsConnectorsList.unableToLoadConnectorTypesMessage', {
            defaultMessage: 'Unable to load connector types'
          })
        });
      } finally {
        setIsLoadingActionTypes(false);
      }
    })();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const actionConnectorTableItems = actionTypesIndex ? actions.map(action => {
    return {
      ...action,
      actionType: actionTypesIndex[action.actionTypeId] ? actionTypesIndex[action.actionTypeId].name : action.actionTypeId,
      compatibility: actionTypesIndex[action.actionTypeId] ? (0, _common.getConnectorCompatibility)(actionTypesIndex[action.actionTypeId].supportedFeatureIds) : []
    };
  }) : [];
  const actionTypesList = actionTypesIndex ? Object.values(actionTypesIndex).map(actionType => ({
    value: actionType.id,
    name: `${actionType.name} (${getActionsCountByActionType(actions, actionType.id)})`
  })).sort((a, b) => a.name.localeCompare(b.name)) : [];
  (0, _react.useEffect)(() => {
    if (connectorId && !isLoadingActions) {
      const connector = actions.find(action => action.id === connectorId);
      if (connector) {
        editItem(connector, _types.EditConnectorTabs.Configuration);
      }
      const linkToConnectors = history.createHref({
        pathname: _constants.routeToConnectors
      });
      window.history.replaceState(null, '', linkToConnectors);
    }
  }, [actions, connectorId, editItem, history, isLoadingActions, location]);
  function setDeleteConnectorWarning(connectors) {
    const show = connectors.some(c => {
      const action = actions.find(a => a.id === c);
      return (action && action.referencedByCount ? action.referencedByCount : 0) > 0;
    });
    setShowWarningText(show);
  }
  function onDelete(items) {
    const itemIds = items.map(item => item.id);
    setConnectorsToDelete(itemIds);
    setDeleteConnectorWarning(itemIds);
  }
  const actionsTableColumns = [{
    field: 'name',
    'data-test-subj': 'connectorsTableCell-name',
    name: _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionsConnectorsList.connectorsListTable.columns.nameTitle', {
      defaultMessage: 'Name'
    }),
    sortable: false,
    truncateText: true,
    render: (value, item) => {
      var _actionTypesIndex$ite;
      const checkEnabledResult = (0, _check_action_type_enabled.checkActionTypeEnabled)(actionTypesIndex && actionTypesIndex[item.actionTypeId], item.isPreconfigured);
      /**
       * TODO: Remove when connectors can provide their own UX message.
       * Issue: https://github.com/elastic/kibana/issues/114507
       */
      const showDeprecatedTooltip = item.isDeprecated;
      const name = getConnectorName(value, item);
      const link = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        gutterSize: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 225,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 226,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": `edit${item.id}`,
        title: name,
        onClick: () => editItem(item, _types.EditConnectorTabs.Configuration),
        key: item.id,
        disabled: actionTypesIndex ? !((_actionTypesIndex$ite = actionTypesIndex[item.actionTypeId]) !== null && _actionTypesIndex$ite !== void 0 && _actionTypesIndex$ite.enabled) : true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 227,
          columnNumber: 15
        }
      }, name)), item.isMissingSecrets ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 238,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        iconProps: {
          'data-test-subj': `missingSecrets_${item.id}`,
          style: {
            verticalAlign: 'text-top'
          }
        },
        type: "warning",
        color: "warning",
        content: _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionsConnectorsList.connectorsListTable.columns.actions.missingSecretsDescription', {
          defaultMessage: 'Sensitive information was not imported'
        }),
        position: "right",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 239,
          columnNumber: 17
        }
      })) : null, showDeprecatedTooltip && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 255,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(ConnectorIconTipWithSpacing, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 256,
          columnNumber: 17
        }
      })));
      return checkEnabledResult.isEnabled ? link : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, link, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        type: "question",
        content: checkEnabledResult.message,
        position: "right",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 267,
          columnNumber: 13
        }
      }));
    }
  }, {
    field: 'actionType',
    'data-test-subj': 'connectorsTableCell-actionType',
    name: _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionsConnectorsList.connectorsListTable.columns.actionTypeTitle', {
      defaultMessage: 'Type'
    }),
    sortable: false,
    truncateText: true
  }, {
    field: 'compatibility',
    'data-test-subj': 'connectorsTableCell-compatibility',
    name: _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionsConnectorsList.connectorsListTable.columns.compatibility', {
      defaultMessage: 'Compatibility'
    }),
    sortable: false,
    truncateText: true,
    render: compatibility => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        wrap: true,
        responsive: false,
        gutterSize: "xs",
        "data-test-subj": "compatibility-content",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 297,
          columnNumber: 11
        }
      }, compatibility.map(compatibilityItem => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        key: compatibilityItem,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 304,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        "data-test-subj": "connectorsTableCell-compatibility-badge",
        color: "default",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 305,
          columnNumber: 17
        }
      }, compatibilityItem))));
    }
  }, {
    name: '',
    render: item => {
      var _actionTypesIndex$ite2;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        justifyContent: "flexEnd",
        alignItems: "center",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 318,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(DeleteOperation, {
        canDelete: canDelete,
        item: item,
        onDelete: () => onDelete([item]),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 319,
          columnNumber: 13
        }
      }), item.isMissingSecrets ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, actionTypesIndex && (_actionTypesIndex$ite2 = actionTypesIndex[item.actionTypeId]) !== null && _actionTypesIndex$ite2 !== void 0 && _actionTypesIndex$ite2.enabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        style: {
          marginLeft: 4
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 323,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionsConnectorsList.connectorsListTable.columns.actions.fixActionDescription', {
          defaultMessage: 'Fix connector configuration'
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 324,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        size: "xs",
        "data-test-subj": "fixConnectorButton",
        onClick: () => editItem(item, _types.EditConnectorTabs.Configuration, true),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 330,
          columnNumber: 23
        }
      }, _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionsConnectorsList.connectorsListTable.columns.fixButtonLabel', {
        defaultMessage: 'Fix'
      })))) : null) : /*#__PURE__*/_react.default.createElement(RunOperation, {
        canExecute: !!(actionTypesIndex && actionTypesIndex[item.actionTypeId] && (0, _capabilities.hasExecuteActionsCapability)(capabilities, actionTypesIndex[item.actionTypeId].subFeature)),
        item: item,
        onRun: () => editItem(item, _types.EditConnectorTabs.Test),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 347,
          columnNumber: 15
        }
      }));
    }
  }];
  const table = /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    loading: isLoadingActions || isLoadingActionTypes,
    items: actionConnectorTableItems,
    sorting: true,
    itemId: "id",
    columns: actionsTableColumns,
    css: disabledActConnectorCss,
    rowProps: item => {
      var _actionTypesIndex$ite3;
      return {
        className: !item.isPreconfigured && (!actionTypesIndex || !((_actionTypesIndex$ite3 = actionTypesIndex[item.actionTypeId]) !== null && _actionTypesIndex$ite3 !== void 0 && _actionTypesIndex$ite3.enabled)) ? 'actConnectorsList__tableRowDisabled' : '',
        'data-test-subj': 'connectors-row'
      };
    },
    cellProps: item => {
      var _actionTypesIndex$ite4;
      return {
        'data-test-subj': 'cell',
        className: !actionTypesIndex || !((_actionTypesIndex$ite4 = actionTypesIndex[item.actionTypeId]) !== null && _actionTypesIndex$ite4 !== void 0 && _actionTypesIndex$ite4.enabled) ? 'actConnectorsList__tableCellDisabled' : ''
      };
    },
    "data-test-subj": "actionsTable",
    pagination: {
      initialPageIndex: 0,
      pageIndex
    },
    onTableChange: ({
      page
    }) => {
      if (page) {
        setPageIndex(page.index);
      }
    },
    selection: canDelete ? {
      onSelectionChange(updatedSelectedItemsList) {
        setSelectedItems(updatedSelectedItemsList);
      },
      selectable: ({
        isPreconfigured
      }) => !isPreconfigured
    } : undefined,
    search: {
      filters: [{
        type: 'field_value_selection',
        field: 'actionTypeId',
        name: _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionsConnectorsList.filters.actionTypeIdName', {
          defaultMessage: 'Type'
        }),
        multiSelect: 'or',
        options: actionTypesList
      }],
      toolsLeft: selectedItems.length === 0 || !canDelete ? [] : [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        key: "delete",
        iconType: "trash",
        color: "danger",
        "data-test-subj": "bulkDelete",
        onClick: () => onDelete(selectedItems),
        title: canDelete ? undefined : _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionsConnectorsList.buttons.deleteDisabledTitle', {
          defaultMessage: 'Unable to delete connectors'
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 428,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.triggersActionsUI.sections.actionsConnectorsList.buttons.deleteLabel",
        defaultMessage: "Delete {count}",
        values: {
          count: selectedItems.length
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 443,
          columnNumber: 19
        }
      }))]
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 369,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    paddingSize: "none",
    "data-test-subj": "actionsList",
    alignment: actionConnectorTableItems.length === 0 ? 'center' : 'top',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 458,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_delete_modal_confirmation.DeleteModalConfirmation, {
    "data-test-subj": "deleteConnectorsConfirmation",
    onDeleted: deleted => {
      if (selectedItems.length === 0 || selectedItems.length === deleted.length) {
        const updatedActions = actions.filter(action => action.id && !connectorsToDelete.includes(action.id));
        setActions(updatedActions);
        setSelectedItems([]);
      }
      setConnectorsToDelete([]);
    },
    onErrors: async () => {
      // Refresh the actions from the server, some actions may have beend deleted
      await loadActions();
      setConnectorsToDelete([]);
    },
    onCancel: async () => {
      setConnectorsToDelete([]);
    },
    apiDeleteCall: _action_connector_api.deleteActions,
    idsToDelete: connectorsToDelete,
    singleTitle: _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionsConnectorsList.singleTitle', {
      defaultMessage: 'connector'
    }),
    multipleTitle: _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionsConnectorsList.multipleTitle', {
      defaultMessage: 'connectors'
    }),
    showWarningText: showWarningText,
    warningText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionsConnectorsList.warningText', {
      defaultMessage: '{connectors, plural, one {This connector is} other {Some connectors are}} currently in use.',
      values: {
        connectors: connectorsToDelete.length
      }
    }),
    setIsLoadingState: isLoading => setIsLoadingActionTypes(isLoading),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 463,
      columnNumber: 9
    }
  }), (isLoadingActions || isLoadingActionTypes) && /*#__PURE__*/_react.default.createElement(_center_justified_spinner.CenterJustifiedSpinner, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 508,
      columnNumber: 56
    }
  }), actionConnectorTableItems.length !== 0 && table, actionConnectorTableItems.length === 0 && canSave && !isLoadingActions && !isLoadingActionTypes && /*#__PURE__*/_react.default.createElement(_empty_connectors_prompt.EmptyConnectorsPrompt, {
    onCTAClicked: () => setAddFlyoutVisibility(true),
    docLinks: docLinks,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 514,
      columnNumber: 13
    }
  }), actionConnectorTableItems.length === 0 && !canSave && /*#__PURE__*/_react.default.createElement(NoPermissionPrompt, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 519,
      columnNumber: 64
    }
  })));
};

// eslint-disable-next-line import/no-default-export
exports.default = ActionsConnectorsList;
function getActionsCountByActionType(actions, actionTypeId) {
  return actions.filter(action => action.actionTypeId === actionTypeId).length;
}
function getConnectorName(name, connector) {
  return connector.isDeprecated ? `${name} ${_connectors_selection.deprecatedMessage}` : name;
}
const DeleteOperation = ({
  item,
  canDelete,
  onDelete
}) => {
  if (item.isPreconfigured) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 543,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
      "data-test-subj": "preConfiguredTitleMessage",
      label: _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionsConnectorsList.preconfiguredTitleMessage', {
        defaultMessage: 'Preconfigured'
      }),
      tooltipContent: "This connector can't be deleted.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 544,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 558,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: canDelete ? _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionsConnectorsList.connectorsListTable.columns.actions.deleteActionDescription', {
      defaultMessage: 'Delete this connector'
    }) : _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionsConnectorsList.connectorsListTable.columns.actions.deleteActionDisabledDescription', {
      defaultMessage: 'Unable to delete connectors'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 559,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    isDisabled: !canDelete,
    "data-test-subj": "deleteConnector",
    "aria-label": _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionsConnectorsList.connectorsListTable.columns.actions.deleteActionName', {
      defaultMessage: 'Delete'
    }),
    onClick: onDelete,
    iconType: 'trash',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 572,
      columnNumber: 9
    }
  })));
};
const RunOperation = ({
  item,
  canExecute,
  onRun
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 593,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: canExecute ? _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionsConnectorsList.connectorsListTable.columns.actions.runConnectorDescription', {
      defaultMessage: 'Run this connector'
    }) : _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionsConnectorsList.connectorsListTable.columns.actions.runConnectorDisabledDescription', {
      defaultMessage: 'Unable to run connectors'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 594,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    isDisabled: !canExecute,
    "data-test-subj": "runConnector",
    "aria-label": _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionsConnectorsList.connectorsListTable.columns.actions.runConnectorName', {
      defaultMessage: 'Run'
    }),
    onClick: onRun,
    iconType: 'play',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 607,
      columnNumber: 9
    }
  })));
};
const NoPermissionPrompt = () => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  iconType: "securityApp",
  title: /*#__PURE__*/_react.default.createElement("h1", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 626,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.actionsConnectorsList.noPermissionToCreateTitle",
    defaultMessage: "No permissions to create connectors",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 627,
      columnNumber: 9
    }
  })),
  body: /*#__PURE__*/_react.default.createElement("p", {
    "data-test-subj": "permissionDeniedMessage",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 634,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.actionsConnectorsList.noPermissionToCreateDescription",
    defaultMessage: "Contact your system administrator.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 635,
      columnNumber: 9
    }
  })),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 623,
    columnNumber: 3
  }
});
module.exports = exports.default;