"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertCounts = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _constants = require("./constants");
var _alert_item = require("./alert_item");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/alert_summary_widget/components/alert_counts.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AlertCounts = ({
  activeAlertCount,
  recoveredAlertCount,
  handleClick
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_alert_item.AlertItem, {
    label: _constants.ALERTS_LABEL,
    count: activeAlertCount + recoveredAlertCount,
    color: euiTheme.colors.vis.euiColorVis0,
    "data-test-subj": _constants.TOTAL_ALERT_COUNT_DATA_TEST_SUBJ,
    handleClick: handleClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_alert_item.AlertItem, {
    label: _constants.ACTIVE_NOW_LABEL,
    count: activeAlertCount,
    color: activeAlertCount > 0 ? euiTheme.colors.textDanger : euiTheme.colors.textSuccess,
    alertType: _ruleDataUtils.ALERT_STATUS_ACTIVE,
    handleClick: handleClick,
    showWarningIcon: true,
    "data-test-subj": _constants.ACTIVE_ALERT_COUNT_DATA_TEST_SUBJ,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }));
};
exports.AlertCounts = AlertCounts;