"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.AlertsSearchBar = AlertsSearchBar;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _esQuery = require("@kbn/es-query");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _use_alerts_data_view = require("@kbn/alerts-ui-shared/src/common/hooks/use_alerts_data_view");
var _quick_filters = require("./quick_filters");
var _constants = require("./constants");
var _translations = require("./translations");
var _kibana = require("../../../common/lib/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/alerts_search_bar/alerts_search_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SA_ALERTS = {
  type: 'alerts',
  fields: {}
};

// TODO Share buildEsQuery to be used between AlertsSearchBar and AlertsStateTable component https://github.com/elastic/kibana/issues/144615
// Also TODO: Replace all references to this component with the one from alerts-ui-shared
function AlertsSearchBar({
  appName,
  disableQueryLanguageSwitcher = false,
  ruleTypeIds,
  query,
  filters,
  quickFilters = [],
  onQueryChange,
  onQuerySubmit,
  onFiltersUpdated,
  rangeFrom,
  rangeTo,
  showFilterBar = false,
  showDatePicker = true,
  showSubmitButton = true,
  placeholder = _translations.SEARCH_BAR_PLACEHOLDER,
  submitOnBlur = false,
  filtersForSuggestions,
  ...props
}) {
  var _ruleTypeIds$some;
  const {
    http,
    dataViews: dataViewsService,
    notifications: {
      toasts
    },
    unifiedSearch: {
      ui: {
        SearchBar
      }
    },
    data: dataService
  } = (0, _kibana.useKibana)().services;
  const [queryLanguage, setQueryLanguage] = (0, _react.useState)('kuery');
  const {
    dataView
  } = (0, _use_alerts_data_view.useAlertsDataView)({
    ruleTypeIds: ruleTypeIds !== null && ruleTypeIds !== void 0 ? ruleTypeIds : [],
    http,
    dataViewsService,
    toasts
  });
  const indexPatterns = (0, _react.useMemo)(() => {
    var _dataView$fields;
    if (ruleTypeIds && dataView !== null && dataView !== void 0 && (_dataView$fields = dataView.fields) !== null && _dataView$fields !== void 0 && _dataView$fields.length) {
      return [{
        title: ruleTypeIds.join(','),
        fields: dataView.fields
      }];
    }
    if (dataView) {
      return [dataView];
    }
    return null;
  }, [dataView, ruleTypeIds]);
  const isSecurity = (_ruleTypeIds$some = ruleTypeIds === null || ruleTypeIds === void 0 ? void 0 : ruleTypeIds.some(_ruleDataUtils.isSiemRuleType)) !== null && _ruleTypeIds$some !== void 0 ? _ruleTypeIds$some : false;
  const onSearchQuerySubmit = (0, _react.useCallback)(({
    dateRange,
    query: nextQuery
  }, isUpdate) => {
    var _nextQuery$language;
    onQuerySubmit({
      dateRange,
      query: typeof (nextQuery === null || nextQuery === void 0 ? void 0 : nextQuery.query) === 'string' ? nextQuery.query : undefined
    }, isUpdate);
    setQueryLanguage((_nextQuery$language = nextQuery === null || nextQuery === void 0 ? void 0 : nextQuery.language) !== null && _nextQuery$language !== void 0 ? _nextQuery$language : 'kuery');
  }, [onQuerySubmit, setQueryLanguage]);
  const onSearchQueryChange = (0, _react.useCallback)(({
    dateRange,
    query: nextQuery
  }) => {
    var _nextQuery$language2;
    onQueryChange === null || onQueryChange === void 0 ? void 0 : onQueryChange({
      dateRange,
      query: typeof (nextQuery === null || nextQuery === void 0 ? void 0 : nextQuery.query) === 'string' ? nextQuery.query : undefined
    });
    setQueryLanguage((_nextQuery$language2 = nextQuery === null || nextQuery === void 0 ? void 0 : nextQuery.language) !== null && _nextQuery$language2 !== void 0 ? _nextQuery$language2 : 'kuery');
  }, [onQueryChange, setQueryLanguage]);
  const onRefresh = ({
    dateRange
  }) => {
    onQuerySubmit({
      dateRange
    });
  };
  const additionalQueryBarMenuItems = (0, _react.useMemo)(() => {
    if (showFilterBar && quickFilters.length > 0) {
      // EuiContextMenu expects a flattened panels structure so here we collect all
      // the nested panels in a linear list
      const panels = [];
      const quickFiltersItemToContextMenuItem = qf => {
        if ((0, _quick_filters.isQuickFiltersGroup)(qf)) {
          var _qf$icon;
          const panelId = `quick-filters-panel-${panels.length}`;
          panels.push({
            id: panelId,
            title: qf.title,
            items: qf.items.map(quickFiltersItemToContextMenuItem),
            'data-test-subj': panelId
          });
          return {
            name: qf.title,
            icon: (_qf$icon = qf.icon) !== null && _qf$icon !== void 0 ? _qf$icon : 'filterInCircle',
            panel: panelId,
            'data-test-subj': `quick-filters-item-${qf.title}`
          };
        } else {
          var _qf$icon2;
          const {
            filter,
            ...menuItem
          } = qf;
          return {
            ...menuItem,
            icon: (_qf$icon2 = qf.icon) !== null && _qf$icon2 !== void 0 ? _qf$icon2 : 'filterInCircle',
            onClick: () => {
              if (!(filters !== null && filters !== void 0 && filters.some(f => (0, _esQuery.compareFilters)(f, filter)))) {
                onFiltersUpdated === null || onFiltersUpdated === void 0 ? void 0 : onFiltersUpdated([...(filters !== null && filters !== void 0 ? filters : []), filter]);
              }
            },
            'data-test-subj': `quick-filters-item-${qf.name}`
          };
        }
      };
      return {
        items: quickFilters.map(quickFiltersItemToContextMenuItem),
        panels
      };
    } else {
      return {
        items: [],
        panels: []
      };
    }
  }, [filters, onFiltersUpdated, quickFilters, showFilterBar]);
  return /*#__PURE__*/_react.default.createElement(SearchBar, (0, _extends2.default)({
    appName: appName,
    disableQueryLanguageSwitcher: disableQueryLanguageSwitcher
    // @ts-expect-error - DataView fields prop and SearchBar indexPatterns props are overly broad
    ,
    indexPatterns: !indexPatterns ? _constants.NO_INDEX_PATTERNS : indexPatterns,
    placeholder: placeholder,
    query: {
      query: query !== null && query !== void 0 ? query : '',
      language: queryLanguage
    },
    filters: filters,
    additionalQueryBarMenuItems: additionalQueryBarMenuItems,
    dateRangeFrom: rangeFrom,
    dateRangeTo: rangeTo,
    displayStyle: "inPage",
    showFilterBar: showFilterBar,
    onQuerySubmit: onSearchQuerySubmit,
    onFiltersUpdated: newFilters => {
      const mappedFilters = structuredClone(newFilters);
      dataService.query.filterManager.setFilters(mappedFilters);
      onFiltersUpdated === null || onFiltersUpdated === void 0 ? void 0 : onFiltersUpdated(mappedFilters);
    },
    onRefresh: onRefresh,
    showDatePicker: showDatePicker,
    showQueryInput: true,
    allowSavingQueries: true,
    showSubmitButton: showSubmitButton,
    submitOnBlur: submitOnBlur,
    onQueryChange: onSearchQueryChange,
    suggestionsAbstraction: isSecurity ? undefined : SA_ALERTS,
    filtersForSuggestions: filtersForSuggestions
  }, props, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 5
    }
  }));
}

// eslint-disable-next-line import/no-default-export