"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RefineSearchPrompt = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/common/components/refine_search_prompt.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_VISIBLE_THRESHOLD = 1000;
const RefineSearchPrompt = props => {
  const {
    documentSize = 0,
    visibleDocumentSize = DEFAULT_VISIBLE_THRESHOLD,
    backToTopAnchor
  } = props;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const textStyles = (0, _react.useMemo)(() => ({
    backgroundColor: euiTheme.colors.lightestShade,
    padding: `${euiTheme.size.m} ${euiTheme.size.base}`,
    marginTop: `${euiTheme.size.xs}`
  }), [euiTheme]);
  if (documentSize < visibleDocumentSize) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    style: textStyles,
    textAlign: "center",
    size: "s",
    "data-test-subj": "refineSearchPrompt",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.refineSearchPrompt.prompt",
    defaultMessage: "These are the first {visibleDocumentSize} documents matching your search, refine your search to see others.",
    values: {
      visibleDocumentSize
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: `#${backToTopAnchor}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.refineSearchPrompt.backToTop",
    defaultMessage: "Back to top.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 9
    }
  })));
};
exports.RefineSearchPrompt = RefineSearchPrompt;