"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleActions = RuleActions;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _responseOpsRuleForm = require("@kbn/response-ops-rule-form");
var _suspended_component_with_props = require("../../../lib/suspended_component_with_props");
var _use_fetch_rule_action_connectors = require("../../../hooks/use_fetch_rule_action_connectors");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/rule_details/components/rule_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function RuleActions({
  ruleActions,
  actionTypeRegistry,
  legacyNotifyWhen
}) {
  const {
    isLoadingActionConnectors,
    actionConnectors
  } = (0, _use_fetch_rule_action_connectors.useFetchRuleActionConnectors)({
    ruleActions
  });
  const hasConnectors = actionConnectors && actionConnectors.length > 0;
  const hasActions = ruleActions && ruleActions.length > 0;
  if (!hasConnectors || !hasActions) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.triggersActionsUI.ruleDetails.noActions', {
      defaultMessage: 'No actions'
    })));
  }
  const getNotifyText = (action, isSystemAction) => {
    if (isSystemAction) {
      return _responseOpsRuleForm.NOTIFY_WHEN_OPTIONS[1].value.inputDisplay;
    }
    if ('frequency' in action) {
      var _ref, _ref2, _notifyWhen$value$inp, _action$frequency2;
      const notifyWhen = _responseOpsRuleForm.NOTIFY_WHEN_OPTIONS.find(options => {
        var _action$frequency;
        return options.value.value === ((_action$frequency = action.frequency) === null || _action$frequency === void 0 ? void 0 : _action$frequency.notifyWhen);
      });
      return (_ref = (_ref2 = (_notifyWhen$value$inp = notifyWhen === null || notifyWhen === void 0 ? void 0 : notifyWhen.value.inputDisplay) !== null && _notifyWhen$value$inp !== void 0 ? _notifyWhen$value$inp : (_action$frequency2 = action.frequency) === null || _action$frequency2 === void 0 ? void 0 : _action$frequency2.notifyWhen) !== null && _ref2 !== void 0 ? _ref2 : legacyNotifyWhen) !== null && _ref !== void 0 ? _ref : '';
    }
    return '';
  };
  const getActionIconClass = actionGroupId => {
    const actionGroup = actionTypeRegistry.list().find(group => group.id === actionGroupId);
    return typeof (actionGroup === null || actionGroup === void 0 ? void 0 : actionGroup.iconClass) === 'string' ? actionGroup === null || actionGroup === void 0 ? void 0 : actionGroup.iconClass : (0, _suspended_component_with_props.suspendedComponentWithProps)(actionGroup === null || actionGroup === void 0 ? void 0 : actionGroup.iconClass);
  };
  const getActionName = actionTypeId => {
    const actionConnector = actionConnectors.find(connector => connector.id === actionTypeId);
    return actionConnector === null || actionConnector === void 0 ? void 0 : actionConnector.name;
  };
  if (isLoadingActionConnectors) return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 41
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 5
    }
  }, ruleActions.map((action, index) => {
    var _getActionIconClass;
    const {
      actionTypeId,
      id
    } = action;
    const actionName = getActionName(id);
    const iconType = (_getActionIconClass = getActionIconClass(actionTypeId)) !== null && _getActionIconClass !== void 0 ? _getActionIconClass : 'apps';
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: index,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      component: "span",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "m",
      type: iconType,
      "data-test-subj": `ruleActionIcon${typeof iconType === 'string' ? `-${iconType}` : ''}`,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      "data-test-subj": `actionConnectorName-${index}-${actionName || actionTypeId}`,
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 17
      }
    }, actionName), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "xs",
      component: "span",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 19
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "s",
      type: "bell",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 21
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      "data-test-subj": `actionConnectorName-notify-text${index}-${actionName || actionTypeId}`,
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 21
      }
    }, String(getNotifyText(action, actionTypeRegistry.get(actionTypeId).isSystemActionType))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 13
      }
    }));
  }));
}