"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleDetailsWithApi = exports.RuleDetails = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _common = require("@kbn/alerting-plugin/common");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _responseOpsRuleForm = require("@kbn/response-ops-rule-form");
var _update_api_key_modal_confirmation = require("../../../components/update_api_key_modal_confirmation");
var _update_api_key = require("../../../lib/rule_api/update_api_key");
var _rules_delete_modal_confirmation = require("../../../components/rules_delete_modal_confirmation");
var _rule_actions_popover = require("./rule_actions_popover");
var _capabilities = require("../../../lib/capabilities");
var _breadcrumb = require("../../../lib/breadcrumb");
var _doc_title = require("../../../lib/doc_title");
var _with_bulk_rule_api_operations = require("../../common/components/with_bulk_rule_api_operations");
var _rule_route = require("./rule_route");
var _view_in_app = require("./view_in_app");
var _constants = require("../../../constants");
var _translations = require("../../rules_list/translations");
var _kibana = require("../../../../common/lib/kibana");
var _action_connector_api = require("../../../lib/action_connector_api");
var _run_rule = require("../../../lib/run_rule");
var _use_bulk_operation_toast = require("../../../hooks/use_bulk_operation_toast");
var _untrack_alerts_modal = require("../../common/components/untrack_alerts_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/rule_details/components/rule_details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ruleDetailStyle = {
  minWidth: 0
};
const RuleDetails = ({
  rule,
  ruleType,
  bulkDisableRules,
  bulkEnableRules,
  bulkDeleteRules,
  requestRefresh,
  refreshToken
}) => {
  var _rule$executionStatus, _rule$executionStatus2, _rule$executionStatus3;
  const history = (0, _reactRouterDom.useHistory)();
  const {
    application: {
      capabilities,
      navigateToApp
    },
    ruleTypeRegistry,
    setBreadcrumbs,
    chrome,
    http,
    i18n: i18nStart,
    theme,
    userProfile,
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  const [rulesToDelete, setRulesToDelete] = (0, _react.useState)([]);
  const [rulesToUpdateAPIKey, setRulesToUpdateAPIKey] = (0, _react.useState)([]);
  const [isUntrackAlertsModalOpen, setIsUntrackAlertsModalOpen] = (0, _react.useState)(false);
  const [hasActionsWithBrokenConnector, setHasActionsWithBrokenConnector] = (0, _react.useState)(false);
  const [config, setConfig] = (0, _react.useState)({
    isUsingSecurity: false
  });
  (0, _react.useEffect)(() => {
    (async () => {
      setConfig(await (0, _responseOpsRuleForm.fetchUiConfig)({
        http
      }));
    })();
  }, [http]);

  // Set breadcrumb and page title
  (0, _react.useEffect)(() => {
    setBreadcrumbs([(0, _breadcrumb.getAlertingSectionBreadcrumb)('rules', true), {
      text: rule.name
    }]);
    chrome.docTitle.change((0, _doc_title.getCurrentDocTitle)('rules'));
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);

  // Determine if any attached action has an issue with its connector
  (0, _react.useEffect)(() => {
    (async () => {
      let loadedConnectors = [];
      try {
        loadedConnectors = await (0, _action_connector_api.loadAllActions)({
          http,
          includeSystemActions: true
        });
      } catch (err) {
        loadedConnectors = [];
      }
      if (loadedConnectors.length > 0) {
        const hasActionWithBrokenConnector = rule.actions.some(action => !loadedConnectors.find(connector => connector.id === action.id));
        if (setHasActionsWithBrokenConnector) {
          setHasActionsWithBrokenConnector(hasActionWithBrokenConnector);
        }
      }
    })();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const canExecuteActions = (0, _capabilities.hasExecuteActionsCapability)(capabilities);
  const canSaveRule = (0, _capabilities.hasAllPrivilege)(rule.consumer, ruleType) && (
  // if the rule has actions, can the user save the rule's action params
  canExecuteActions || !canExecuteActions && rule.actions.length === 0);
  const hasEditButton =
  // can the user save the rule
  canSaveRule && (
  // is this rule type editable from within Rules Management
  ruleTypeRegistry.has(rule.ruleTypeId) ? !ruleTypeRegistry.get(rule.ruleTypeId).requiresAppContext : false) && !ruleType.isInternallyManaged;
  const onRunRule = async id => {
    await (0, _run_rule.runRule)(http, toasts, id);
  };

  // Check whether interval is below configured minium
  (0, _react.useEffect)(() => {
    if (rule.schedule.interval && config.minimumScheduleInterval) {
      if ((0, _common.parseDuration)(rule.schedule.interval) < (0, _common.parseDuration)(config.minimumScheduleInterval.value)) {
        const configurationToast = toasts.addInfo({
          'data-test-subj': 'intervalConfigToast',
          title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.scheduleIntervalToastTitle', {
            defaultMessage: 'Configuration settings'
          }),
          text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 187,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.triggersActionsUI.sections.ruleDetails.scheduleIntervalToastMessage",
            defaultMessage: "This rule has an interval set below the minimum configured interval. This may impact performance.",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 188,
              columnNumber: 17
            }
          })), hasEditButton && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
            justifyContent: "flexEnd",
            gutterSize: "s",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 194,
              columnNumber: 17
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 195,
              columnNumber: 19
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
            "data-test-subj": "ruleIntervalToastEditButton",
            onClick: () => {
              toasts.remove(configurationToast);
              onEditRuleClick();
            },
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 196,
              columnNumber: 21
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.triggersActionsUI.sections.ruleDetails.scheduleIntervalToastMessageButton",
            defaultMessage: "Edit rule",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 203,
              columnNumber: 23
            }
          }))))), {
            i18n: i18nStart,
            theme,
            userProfile
          })
        });
      }
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [i18nStart, theme, userProfile, rule.schedule.interval, config.minimumScheduleInterval, toasts, hasEditButton]);
  const goToRulesList = () => {
    history.push(_constants.routeToRules);
  };
  const getRuleStatusErrorReasonText = () => {
    if (rule.executionStatus.error && rule.executionStatus.error.reason) {
      return _translations.rulesErrorReasonTranslationsMapping[rule.executionStatus.error.reason];
    } else {
      return _translations.rulesErrorReasonTranslationsMapping.unknown;
    }
  };
  const getRuleStatusWarningReasonText = () => {
    if (rule.executionStatus.warning && rule.executionStatus.warning.reason) {
      return _translations.rulesWarningReasonTranslationsMapping[rule.executionStatus.warning.reason];
    } else {
      return _translations.rulesWarningReasonTranslationsMapping.unknown;
    }
  };
  const onEditRuleClick = () => {
    navigateToApp('management', {
      path: `insightsAndAlerting/triggersActions/${(0, _ruleDataUtils.getEditRuleRoute)(rule.id)}`,
      state: {
        returnApp: 'management',
        returnPath: `insightsAndAlerting/triggersActions/${(0, _ruleDataUtils.getRuleDetailsRoute)(rule.id)}`
      }
    });
  };
  const editButton = hasEditButton ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.editRuleButtonLabel', {
      defaultMessage: 'Edit'
    }),
    "data-test-subj": "openEditRuleFlyoutButton",
    iconType: "pencil",
    onClick: onEditRuleClick,
    name: "edit",
    disabled: !ruleType.enabledInLicense,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.ruleDetails.editRuleButtonLabel",
    defaultMessage: "Edit",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 273,
      columnNumber: 9
    }
  }))) : null;
  const [isDeleteModalFlyoutVisible, setIsDeleteModalVisibility] = (0, _react.useState)(false);
  const {
    showToast
  } = (0, _use_bulk_operation_toast.useBulkOperationToast)({});
  const onDeleteConfirm = async () => {
    setIsDeleteModalVisibility(false);
    const {
      errors,
      total
    } = await bulkDeleteRules({
      ids: rulesToDelete
    });
    showToast({
      action: 'DELETE',
      errors,
      total
    });
    setRulesToDelete([]);
    goToRulesList();
  };
  const onDeleteCancel = () => {
    setIsDeleteModalVisibility(false);
    setRulesToDelete([]);
  };
  const onDisableModalOpen = () => {
    setIsUntrackAlertsModalOpen(true);
  };
  const onDisableModalClose = () => {
    setIsUntrackAlertsModalOpen(false);
  };
  const onEnable = async () => {
    await bulkEnableRules({
      ids: [rule.id]
    });
    requestRefresh();
  };
  const onDisable = async untrack => {
    onDisableModalClose();
    await bulkDisableRules({
      ids: [rule.id],
      untrack
    });
    requestRefresh();
  };
  const onEnableDisable = enable => {
    if (enable) {
      onEnable();
    } else if (ruleType.autoRecoverAlerts === false) {
      onDisable(false);
    } else {
      onDisableModalOpen();
    }
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isDeleteModalFlyoutVisible && /*#__PURE__*/_react.default.createElement(_rules_delete_modal_confirmation.RulesDeleteModalConfirmation, {
    onConfirm: onDeleteConfirm,
    onCancel: onDeleteCancel,
    confirmButtonText: (0, _translations.getConfirmDeletionButtonText)(rulesToDelete.length, _translations.SINGLE_RULE_TITLE, _translations.MULTIPLE_RULE_TITLE),
    confirmModalText: (0, _translations.getConfirmDeletionModalText)(rulesToDelete.length, _translations.SINGLE_RULE_TITLE, _translations.MULTIPLE_RULE_TITLE),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 331,
      columnNumber: 9
    }
  }), isUntrackAlertsModalOpen && /*#__PURE__*/_react.default.createElement(_untrack_alerts_modal.UntrackAlertsModal, {
    onCancel: onDisableModalClose,
    onConfirm: onDisable,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 347,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_update_api_key_modal_confirmation.UpdateApiKeyModalConfirmation, {
    onCancel: () => {
      setRulesToUpdateAPIKey([]);
    },
    idsToUpdate: rulesToUpdateAPIKey,
    apiUpdateApiKeyCall: _update_api_key.bulkUpdateAPIKey,
    setIsLoadingState: () => {},
    onUpdated: async () => {
      setRulesToUpdateAPIKey([]);
      requestRefresh();
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 349,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    "data-test-subj": "ruleDetailsTitle",
    bottomBorder: true,
    pageTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.sections.ruleDetails.ruleDetailsTitle",
      defaultMessage: "{ruleName}",
      values: {
        ruleName: rule.name
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 365,
        columnNumber: 11
      }
    }),
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 372,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 373,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      gutterSize: "s",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 374,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 375,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 376,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 377,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.sections.rulesList.rulesListTable.columns.ruleTypeTitle",
      defaultMessage: "Type",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 378,
        columnNumber: 23
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 385,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      "data-test-subj": "ruleTypeLabel",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 386,
        columnNumber: 19
      }
    }, ruleType.name)))), (0, _capabilities.hasManageApiKeysCapability)(capabilities) && rule.apiKeyOwner && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 391,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      gutterSize: "s",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 392,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 393,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 394,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 395,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.sections.rulesList.rulesListTable.columns.apiKeyOwnerTitle",
      defaultMessage: "API key owner",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 396,
        columnNumber: 25
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 403,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      "data-test-subj": "apiKeyOwnerLabel",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 404,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement("b", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 405,
        columnNumber: 23
      }
    }, rule.apiKeyOwner), rule.apiKeyCreatedByUser ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      position: "right",
      content: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.userManagedApikey', {
        defaultMessage: 'This rule is associated with an API key.'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 409,
        columnNumber: 27
      }
    })) : null))))),
    rightSideItems: [canSaveRule && /*#__PURE__*/_react.default.createElement(_rule_actions_popover.RuleActionsPopover, {
      rule: rule,
      onDelete: ruleId => {
        setIsDeleteModalVisibility(true);
        setRulesToDelete([ruleId]);
      },
      onApiKeyUpdate: ruleId => {
        setRulesToUpdateAPIKey([ruleId]);
      },
      onEnableDisable: onEnableDisable,
      onRunRule: onRunRule,
      isInternallyManaged: ruleType.isInternallyManaged,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 429,
        columnNumber: 13
      }
    }), editButton, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "aria-label": _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.refreshRulesButtonLabel', {
        defaultMessage: 'Refresh'
      }),
      "data-test-subj": "refreshRulesButton",
      iconType: "refresh",
      onClick: requestRefresh,
      name: "refresh",
      color: "primary",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 444,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.sections.rulesList.refreshRulesButtonLabel",
      defaultMessage: "Refresh",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 457,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_view_in_app.ViewInApp, {
      rule: rule,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 462,
        columnNumber: 11
      }
    })],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 361,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 465,
      columnNumber: 7
    }
  }, rule.enabled && ((_rule$executionStatus = rule.executionStatus.error) === null || _rule$executionStatus === void 0 ? void 0 : _rule$executionStatus.reason) === _common.RuleExecutionStatusErrorReasons.License ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 468,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 469,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    color: "danger",
    "data-test-subj": "ruleErrorBanner",
    size: "s",
    iconType: "error",
    title: getRuleStatusErrorReasonText(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 470,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 478,
      columnNumber: 17
    }
  }, (_rule$executionStatus2 = rule.executionStatus.error) === null || _rule$executionStatus2 === void 0 ? void 0 : _rule$executionStatus2.message), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 479,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: `${http.basePath.get()}/app/management/stack/license_management`,
    color: "primary",
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 480,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.ruleDetails.manageLicensePlanBannerLinkTitle",
    defaultMessage: "Manage license",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 485,
      columnNumber: 19
    }
  }))))) : null, rule.enabled && rule.executionStatus.status === 'warning' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 495,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 496,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    color: "warning",
    "data-test-subj": "ruleWarningBanner",
    size: "s",
    iconType: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 497,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 504,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: "warning",
    type: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 505,
      columnNumber: 19
    }
  }), "\xA0", getRuleStatusWarningReasonText(), "\xA0", (_rule$executionStatus3 = rule.executionStatus.warning) === null || _rule$executionStatus3 === void 0 ? void 0 : _rule$executionStatus3.message)))) : null, hasActionsWithBrokenConnector && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 516,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 517,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 518,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    color: "warning",
    "data-test-subj": "actionWithBrokenConnectorWarningBanner",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 519,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 525,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: "warning",
    type: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 526,
      columnNumber: 19
    }
  }), "\xA0", /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.ruleDetails.actionWithBrokenConnectorWarningBannerTitle",
    defaultMessage: "There is an issue with one of the connectors associated with this rule.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 528,
      columnNumber: 19
    }
  }), "\xA0", hasEditButton && /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "actionWithBrokenConnectorWarningBannerEdit",
    color: "primary",
    onClick: onEditRuleClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 534,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.ruleDetails.actionWithBrokenConnectorWarningBannerEditText",
    defaultMessage: "Edit rule",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 539,
      columnNumber: 23
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 550,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: ruleDetailStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 551,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_rule_route.RuleRouteWithApi, {
    requestRefresh: requestRefresh,
    refreshToken: refreshToken,
    rule: rule,
    ruleType: ruleType,
    readOnly: !canSaveRule,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 552,
      columnNumber: 13
    }
  })))));
};
exports.RuleDetails = RuleDetails;
const RuleDetailsWithApi = exports.RuleDetailsWithApi = (0, _with_bulk_rule_api_operations.withBulkRuleOperations)(RuleDetails);