"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.RuleDetailsRoute = void 0;
exports.getRuleData = getRuleData;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _rule_details = require("./rule_details");
var _value_validators = require("../../../lib/value_validators");
var _with_bulk_rule_api_operations = require("../../common/components/with_bulk_rule_api_operations");
var _with_actions_api_operations = require("../../common/components/with_actions_api_operations");
var _kibana = require("../../../../common/lib/kibana");
var _center_justified_spinner = require("../../../components/center_justified_spinner");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/rule_details/components/rule_details_route.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RuleDetailsRoute = ({
  match: {
    params: {
      ruleId
    }
  },
  loadRuleTypes,
  loadActionTypes,
  resolveRule
}) => {
  const {
    http,
    notifications: {
      toasts
    },
    spaces: spacesApi
  } = (0, _kibana.useKibana)().services;
  const {
    basePath
  } = http;
  const [rule, setRule] = (0, _react.useState)(null);
  const [ruleType, setRuleType] = (0, _react.useState)(null);
  const [actionTypes, setActionTypes] = (0, _react.useState)(null);
  const [refreshToken, setRefreshToken] = (0, _react.useState)();
  const requestRefresh = (0, _react.useCallback)(() => new Promise((resolve, reject) => {
    setRefreshToken({
      resolve,
      reject
    });
  }), [setRefreshToken]);
  (0, _react.useEffect)(() => {
    const loadData = async () => {
      await getRuleData(ruleId, loadRuleTypes, resolveRule, loadActionTypes, setRule, setRuleType, setActionTypes, toasts);
      refreshToken === null || refreshToken === void 0 ? void 0 : refreshToken.resolve();
    };
    loadData();
  }, [ruleId, http, loadActionTypes, loadRuleTypes, resolveRule, toasts, refreshToken]);
  (0, _react.useEffect)(() => {
    if (rule) {
      const outcome = rule.outcome;
      if (spacesApi && outcome === 'aliasMatch') {
        // This rule has been resolved from a legacy URL - redirect the user to the new URL and display a toast.
        const path = basePath.prepend(`insightsAndAlerting/triggersActions/rule/${rule.id}`);
        spacesApi.ui.redirectLegacyUrl({
          path,
          aliasPurpose: rule.alias_purpose,
          objectNoun: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.redirectObjectNoun', {
            defaultMessage: 'rule'
          })
        });
      }
    }
  }, [rule, spacesApi, basePath]);
  const getLegacyUrlConflictCallout = () => {
    const outcome = rule.outcome;
    if (spacesApi && outcome === 'conflict') {
      const aliasTargetId = rule.alias_target_id; // This is always defined if outcome === 'conflict'
      // We have resolved to one rule, but there is another one with a legacy URL associated with this page. Display a
      // callout with a warning for the user, and provide a way for them to navigate to the other rule.
      const otherRulePath = basePath.prepend(`insightsAndAlerting/triggersActions/rule/${aliasTargetId}`);
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 111,
          columnNumber: 11
        }
      }), spacesApi.ui.components.getLegacyUrlConflict({
        objectNoun: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.redirectObjectNoun', {
          defaultMessage: 'rule'
        }),
        currentObjectId: rule === null || rule === void 0 ? void 0 : rule.id,
        otherObjectId: aliasTargetId,
        otherObjectPath: otherRulePath
      }));
    }
    return null;
  };
  if (rule && ruleType && actionTypes) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, getLegacyUrlConflictCallout(), /*#__PURE__*/_react.default.createElement(_rule_details.RuleDetailsWithApi, {
      rule: rule,
      ruleType: ruleType,
      actionTypes: actionTypes,
      requestRefresh: requestRefresh,
      refreshToken: refreshToken,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_center_justified_spinner.CenterJustifiedSpinner, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 10
    }
  });
};
exports.RuleDetailsRoute = RuleDetailsRoute;
async function getRuleData(ruleId, loadRuleTypes, resolveRule, loadActionTypes, setRule, setRuleType, setActionTypes, toasts) {
  try {
    const loadedRule = await resolveRule(ruleId);
    setRule(loadedRule);
    const [loadedRuleType, loadedActionTypes] = await Promise.all([loadRuleTypes().then(types => types.find(type => type.id === loadedRule.ruleTypeId)).then((0, _value_validators.throwIfAbsent)(`Invalid Rule Type: ${loadedRule.ruleTypeId}`)), loadActionTypes().then((0, _value_validators.throwIfIsntContained)(new Set(loadedRule.actions.map(action => action.actionTypeId)), requiredActionType => `Invalid Connector Type: ${requiredActionType}`, action => action.id))]);
    setRuleType(loadedRuleType);
    setActionTypes(loadedActionTypes);
  } catch (e) {
    toasts.addDanger({
      title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.unableToLoadRuleMessage', {
        defaultMessage: 'Unable to load rule: {message}',
        values: {
          message: e.message
        }
      })
    });
  }
}
const RuleDetailsRouteWithApi = exports.default = (0, _with_actions_api_operations.withActionOperations)((0, _with_bulk_rule_api_operations.withBulkRuleOperations)(RuleDetailsRoute));
// eslint-disable-next-line import/no-default-export