"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BulkSnoozeModalWithApi = exports.BulkSnoozeModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _with_bulk_rule_api_operations = require("../../common/components/with_bulk_rule_api_operations");
var _rule_snooze = require("./rule_snooze");
var _use_bulk_edit_response = require("../../../hooks/use_bulk_edit_response");
var _kibana = require("../../../../common/lib/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/rules_list/components/bulk_snooze_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const failureMessage = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.bulkSnoozeFailMessage', {
  defaultMessage: 'Failed to bulk snooze rules'
});
const deleteConfirmPlural = total => _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.bulkUnsnoozeConfirmationPlural', {
  defaultMessage: 'Unsnooze {total, plural, one {# rule} other {# rules}}? ',
  values: {
    total
  }
});
const deleteConfirmSingle = ruleName => _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.bulkUnsnoozeConfirmationSingle', {
  defaultMessage: 'Unsnooze {ruleName}?',
  values: {
    ruleName
  }
});
const BulkSnoozeModal = props => {
  const {
    bulkEditAction,
    rules,
    filter,
    numberOfSelectedRules = 0,
    onClose,
    onSave,
    setIsBulkEditing,
    onSearchPopulate,
    bulkSnoozeRules,
    bulkUnsnoozeRules
  } = props;
  const confirmModalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  const {
    showToast
  } = (0, _use_bulk_edit_response.useBulkEditResponse)({
    onSearchPopulate
  });
  const interval = (0, _react.useMemo)(() => {
    if (filter) {
      return;
    }
    const rule = rules.find(item => item.isSnoozedUntil);
    if (rule) {
      return (0, _rule_snooze.futureTimeToInterval)(rule.isSnoozedUntil);
    }
  }, [rules, filter]);
  const onSnoozeRule = async schedule => {
    onClose();
    setIsBulkEditing(true);
    try {
      const response = await bulkSnoozeRules({
        ids: rules.map(item => item.id),
        filter,
        snoozeSchedule: schedule
      });
      showToast(response, 'snooze');
    } catch (error) {
      toasts.addError(error, {
        title: failureMessage
      });
    }
    setIsBulkEditing(false);
    onSave();
  };
  const onUnsnoozeRule = async () => {
    onClose();
    setIsBulkEditing(true);
    try {
      const response = await bulkUnsnoozeRules({
        ids: rules.map(item => item.id),
        filter
      });
      showToast(response, 'snooze');
    } catch (error) {
      toasts.addError(error, {
        title: failureMessage
      });
    }
    setIsBulkEditing(false);
    onSave();
  };
  const confirmationTitle = (0, _react.useMemo)(() => {
    if (!filter && numberOfSelectedRules === 1 && rules[0]) {
      return deleteConfirmSingle(rules[0].name);
    }
    return deleteConfirmPlural(numberOfSelectedRules);
  }, [rules, filter, numberOfSelectedRules]);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  if (bulkEditAction === 'unsnooze' && (rules.length || filter)) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
      "aria-labelledby": confirmModalTitleId,
      title: confirmationTitle,
      titleProps: {
        id: confirmModalTitleId
      },
      onCancel: onClose,
      onConfirm: onUnsnoozeRule,
      confirmButtonText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.bulkUnsnoozeConfirmButton', {
        defaultMessage: 'Unsnooze'
      }),
      cancelButtonText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.bulkUnsnoozeCancelButton', {
        defaultMessage: 'Cancel'
      }),
      buttonColor: "danger",
      defaultFocusedButton: "confirm",
      "data-test-subj": "bulkUnsnoozeConfirmationModal",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 7
      }
    });
  }
  if (bulkEditAction === 'snooze' && (rules.length || filter)) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
      onClose: onClose,
      "aria-labelledby": modalTitleId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 167,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 168,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
      id: modalTitleId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 169,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.sections.rulesList.bulkSnoozeModal.modalTitle",
      defaultMessage: "Add snooze now",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 170,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 175,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_rule_snooze.SnoozePanel, {
      hasTitle: false,
      showCancel: false,
      showAddSchedule: false,
      interval: interval,
      snoozeRule: onSnoozeRule,
      unsnoozeRule: onUnsnoozeRule,
      scheduledSnoozes: [],
      activeSnoozes: [],
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 178,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 189,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: onClose,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 190,
        columnNumber: 11
      }
    }, "Close")));
  }
  return null;
};
exports.BulkSnoozeModal = BulkSnoozeModal;
const BulkSnoozeModalWithApi = exports.BulkSnoozeModalWithApi = (0, _with_bulk_rule_api_operations.withBulkRuleOperations)(BulkSnoozeModal);