"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BulkSnoozeScheduleModalWithApi = exports.BulkSnoozeScheduleModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _with_bulk_rule_api_operations = require("../../common/components/with_bulk_rule_api_operations");
var _scheduler = require("./rule_snooze/scheduler");
var _use_bulk_edit_response = require("../../../hooks/use_bulk_edit_response");
var _kibana = require("../../../../common/lib/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/rules_list/components/bulk_snooze_schedule_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const failureMessage = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.bulkSnoozeScheduleFailMessage', {
  defaultMessage: 'Failed to bulk snooze rules'
});
const deleteConfirmPlural = total => _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.bulkDeleteConfirmationPlural', {
  defaultMessage: 'Delete all snooze schedules for {total, plural, one {# rule} other {# rules}}? ',
  values: {
    total
  }
});
const deleteConfirmSingle = ruleName => _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.bulkDeleteConfirmationSingle', {
  defaultMessage: 'Delete all snooze schedules for {ruleName}?',
  values: {
    ruleName
  }
});
const BulkSnoozeScheduleModal = props => {
  const {
    rules,
    filter,
    bulkEditAction,
    numberOfSelectedRules = 0,
    onClose,
    onSave,
    bulkSnoozeRules,
    bulkUnsnoozeRules,
    setIsBulkEditing,
    onSearchPopulate
  } = props;
  const {
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  const {
    showToast
  } = (0, _use_bulk_edit_response.useBulkEditResponse)({
    onSearchPopulate
  });
  const onAddSnoozeSchedule = async schedule => {
    onClose();
    setIsBulkEditing(true);
    try {
      const response = await bulkSnoozeRules({
        ids: rules.map(item => item.id),
        filter,
        snoozeSchedule: schedule
      });
      showToast(response, 'snoozeSchedule');
    } catch (error) {
      toasts.addError(error, {
        title: failureMessage
      });
    }
    setIsBulkEditing(false);
    onSave();
  };
  const onRemoveSnoozeSchedule = async () => {
    onClose();
    setIsBulkEditing(true);
    try {
      const response = await bulkUnsnoozeRules({
        ids: rules.map(item => item.id),
        filter,
        scheduleIds: []
      });
      showToast(response, 'snoozeSchedule');
    } catch (error) {
      toasts.addError(error, {
        title: failureMessage
      });
    }
    setIsBulkEditing(false);
    onSave();
  };
  const confirmationTitle = (0, _react.useMemo)(() => {
    if (!filter && numberOfSelectedRules === 1 && rules[0]) {
      return deleteConfirmSingle(rules[0].name);
    }
    return deleteConfirmPlural(numberOfSelectedRules);
  }, [rules, filter, numberOfSelectedRules]);
  const confirmModalTitleId = (0, _eui.useGeneratedHtmlId)();
  const modalHeaderTitleId = (0, _eui.useGeneratedHtmlId)();
  if (bulkEditAction === 'unschedule' && (rules.length || filter)) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
      "aria-labelledby": confirmModalTitleId,
      titleProps: {
        id: confirmModalTitleId
      },
      title: confirmationTitle,
      onCancel: onClose,
      onConfirm: onRemoveSnoozeSchedule,
      confirmButtonText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.bulkDeleteConfirmButton', {
        defaultMessage: 'Delete'
      }),
      cancelButtonText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.bulkDeleteCancelButton', {
        defaultMessage: 'Cancel'
      }),
      buttonColor: "danger",
      defaultFocusedButton: "confirm",
      "data-test-subj": "bulkRemoveScheduleConfirmationModal",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 7
      }
    });
  }
  if (bulkEditAction === 'schedule' && (rules.length || filter)) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
      "aria-labelledby": modalHeaderTitleId,
      onClose: onClose,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 159,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
      id: modalHeaderTitleId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 160,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.sections.rulesList.bulkSnoozeScheduleModal.modalTitle",
      defaultMessage: "Add snooze schedule",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 161,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 166,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 168,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_scheduler.RuleSnoozeScheduler, {
      bulkSnoozeSchedule: true,
      hasTitle: false,
      isLoading: false,
      initialSchedule: null,
      onSaveSchedule: onAddSnoozeSchedule,
      onCancelSchedules: onRemoveSnoozeSchedule,
      onClose: () => {},
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 169,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 179,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: onClose,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 180,
        columnNumber: 11
      }
    }, "Close")));
  }
  return null;
};
exports.BulkSnoozeScheduleModal = BulkSnoozeScheduleModal;
const BulkSnoozeScheduleModalWithApi = exports.BulkSnoozeScheduleModalWithApi = (0, _with_bulk_rule_api_operations.withBulkRuleOperations)(BulkSnoozeScheduleModal);