"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CollapsedItemActionsWithApi = exports.CollapsedItemActions = void 0;
var _i18n = require("@kbn/i18n");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _rxjs = require("rxjs");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _kibana = require("../../../../common/lib/kibana");
var _with_bulk_rule_api_operations = require("../../common/components/with_bulk_rule_api_operations");
var _lib = require("../../../lib");
var _rule_snooze = require("./rule_snooze");
var _notify_badge = require("./notify_badge");
var _untrack_alerts_modal = require("../../common/components/untrack_alerts_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/rules_list/components/collapsed_item_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CollapsedItemActions = ({
  item,
  onLoading,
  onRuleChanged,
  bulkDisableRules,
  bulkEnableRules,
  onDeleteRule,
  onEditRule,
  onUpdateAPIKey,
  snoozeRule,
  unsnoozeRule,
  onRunRule,
  onCloneRule
}) => {
  var _item$snoozeSchedule, _item$activeSnoozes;
  const {
    ruleTypeRegistry,
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const [isDisabled, setIsDisabled] = (0, _react.useState)(!item.enabled);
  const [isUntrackAlertsModalOpen, setIsUntrackAlertsModalOpen] = (0, _react.useState)(false);
  const collapsedItemActionsCss = (0, _react2.css)`
    .collapsedItemActions__deleteButton {
      color: ${euiTheme.colors.textDanger};
    }
  `;
  (0, _react.useEffect)(() => {
    setIsDisabled(!item.enabled);
  }, [item.enabled]);
  const onClose = (0, _react.useCallback)(() => {
    setIsPopoverOpen(false);
  }, [setIsPopoverOpen]);
  const snoozeRuleInternal = (0, _react.useCallback)(async snoozeSchedule => {
    try {
      onLoading(true);
      await snoozeRule(item, snoozeSchedule);
      await onRuleChanged();
      toasts.addSuccess(_notify_badge.SNOOZE_SUCCESS_MESSAGE);
    } catch (e) {
      toasts.addDanger(_notify_badge.SNOOZE_FAILED_MESSAGE);
    } finally {
      onLoading(false);
      onClose();
    }
    await snoozeRule(item, snoozeSchedule);
  }, [onLoading, snoozeRule, item, onRuleChanged, toasts, onClose]);
  const unsnoozeRuleInternal = (0, _react.useCallback)(async scheduleIds => {
    try {
      onLoading(true);
      await unsnoozeRule(item, scheduleIds);
      await onRuleChanged();
      toasts.addSuccess(_notify_badge.UNSNOOZE_SUCCESS_MESSAGE);
    } catch (e) {
      toasts.addDanger(_notify_badge.SNOOZE_FAILED_MESSAGE);
    } finally {
      onLoading(false);
      onClose();
    }
  }, [onLoading, unsnoozeRule, item, onRuleChanged, toasts, onClose]);
  const isRuleTypeEditableInContext = ruleTypeRegistry.has(item.ruleTypeId) ? !ruleTypeRegistry.get(item.ruleTypeId).requiresAppContext : false;
  const isSnoozed = (0, _react.useMemo)(() => {
    return (0, _lib.isRuleSnoozed)(item);
  }, [item]);
  const snoozedButtonText = (0, _react.useMemo)(() => {
    if (item.muteAll) {
      return _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.collapsedItemActions.snoozedIndefinitely', {
        defaultMessage: 'Snoozed indefinitely'
      });
    }
    if (isSnoozed) {
      return _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.collapsedItemActions.snoozedUntil', {
        defaultMessage: 'Snoozed until {snoozeTime}',
        values: {
          snoozeTime: (0, _moment.default)(item.isSnoozedUntil).format('MMM D')
        }
      });
    }
    return _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.collapsedItemActions.snooze', {
      defaultMessage: 'Snooze'
    });
  }, [isSnoozed, item]);
  const snoozePanelItem = (0, _react.useMemo)(() => {
    if (isDisabled || item.consumer === _ruleDataUtils.AlertConsumers.SIEM) {
      return [];
    }
    return [{
      disabled: !item.isEditable || !item.enabledInLicense,
      'data-test-subj': 'snoozeButton',
      icon: 'bellSlash',
      name: snoozedButtonText,
      panel: 1
    }];
  }, [isDisabled, item, snoozedButtonText]);
  const onDisableModalOpen = (0, _react.useCallback)(() => {
    setIsUntrackAlertsModalOpen(true);
  }, []);
  const onDisableModalClose = (0, _react.useCallback)(() => {
    setIsUntrackAlertsModalOpen(false);
  }, []);
  const onEnable = (0, _react.useCallback)(async () => {
    _rxjs.asyncScheduler.schedule(async () => {
      await bulkEnableRules({
        ids: [item.id]
      });
      onRuleChanged();
    }, 10);
    setIsDisabled(false);
    setIsPopoverOpen(false);
  }, [bulkEnableRules, onRuleChanged, item.id]);
  const onDisable = (0, _react.useCallback)(async untrack => {
    onDisableModalClose();
    await bulkDisableRules({
      ids: [item.id],
      untrack
    });
    onRuleChanged();
    setIsDisabled(true);
    setIsPopoverOpen(false);
  }, [onDisableModalClose, bulkDisableRules, onRuleChanged, item.id]);
  const onDisableClick = (0, _react.useCallback)(() => {
    if (isDisabled) {
      onEnable();
    } else if (item.autoRecoverAlerts === false) {
      onDisable(false);
    } else {
      onDisableModalOpen();
    }
  }, [isDisabled, item.autoRecoverAlerts, onEnable, onDisableModalOpen, onDisable]);
  const getUpdateApiKeyPanelItem = testId => ({
    disabled: !item.isEditable,
    'data-test-subj': testId,
    onClick: () => {
      setIsPopoverOpen(!isPopoverOpen);
      onUpdateAPIKey(item);
    },
    name: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.collapsedItemActions.updateApiKey', {
      defaultMessage: 'Update API key'
    })
  });
  const getDisablePanelItem = testId => ({
    disabled: !item.isEditable || !item.enabledInLicense,
    'data-test-subj': testId,
    onClick: onDisableClick,
    name: isDisabled ? _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.collapsedItemActons.enableTitle', {
      defaultMessage: 'Enable'
    }) : _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.collapsedItemActons.disableTitle', {
      defaultMessage: 'Disable'
    })
  });
  const panels = item.isInternallyManaged ? [{
    id: 0,
    hasFocus: true,
    items: [getDisablePanelItem('disableButtonInternallyManaged'), getUpdateApiKeyPanelItem('updateApiKeyInternallyManaged')]
  }] : [{
    id: 0,
    hasFocus: false,
    items: [...snoozePanelItem, {
      isSeparator: true
    }, getDisablePanelItem('disableButton'), {
      disabled: !item.isEditable || item.consumer === _ruleDataUtils.AlertConsumers.SIEM,
      'data-test-subj': 'cloneRule',
      onClick: async () => {
        setIsPopoverOpen(!isPopoverOpen);
        onCloneRule(item.id);
      },
      name: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.collapsedItemActons.cloneRuleTitle', {
        defaultMessage: 'Clone rule'
      })
    }, {
      disabled: !item.isEditable || !isRuleTypeEditableInContext,
      'data-test-subj': 'editRule',
      onClick: () => {
        setIsPopoverOpen(!isPopoverOpen);
        onEditRule(item);
      },
      name: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.collapsedItemActons.editTitle', {
        defaultMessage: 'Edit rule'
      })
    }, getUpdateApiKeyPanelItem('updateApiKey'), {
      disabled: !item.isEditable,
      'data-test-subj': 'runRule',
      onClick: () => {
        setIsPopoverOpen(!isPopoverOpen);
        onRunRule(item);
      },
      name: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.collapsedItemActions.runRule', {
        defaultMessage: 'Run rule'
      })
    }, {
      disabled: !item.isEditable,
      className: 'collapsedItemActions__deleteButton',
      'data-test-subj': 'deleteRule',
      onClick: () => {
        setIsPopoverOpen(!isPopoverOpen);
        onDeleteRule(item);
      },
      name: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.collapsedItemActons.deleteRuleTitle', {
        defaultMessage: 'Delete rule'
      })
    }]
  }, {
    id: 1,
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 320,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 321,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "bellSlash",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 322,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 324,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.collapsedItemActons.snoozeActions', {
      defaultMessage: 'Snooze notifications'
    }))),
    width: 500,
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 334,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_rule_snooze.SnoozePanel, {
      interval: (0, _rule_snooze.futureTimeToInterval)(item.isSnoozedUntil),
      hasTitle: false,
      scheduledSnoozes: (_item$snoozeSchedule = item.snoozeSchedule) !== null && _item$snoozeSchedule !== void 0 ? _item$snoozeSchedule : [],
      activeSnoozes: (_item$activeSnoozes = item.activeSnoozes) !== null && _item$activeSnoozes !== void 0 ? _item$activeSnoozes : [],
      showCancel: (0, _lib.isRuleSnoozed)(item),
      snoozeRule: snoozeRuleInternal,
      unsnoozeRule: unsnoozeRuleInternal,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 335,
        columnNumber: 15
      }
    }))
  }];
  return item.isEditable && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "selectActionButton",
      "data-testid": "selectActionButton",
      iconType: "boxesHorizontal",
      onClick: () => setIsPopoverOpen(!isPopoverOpen),
      "aria-label": _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.collapsedItemActons.popoverButtonTitle', {
        defaultMessage: 'Actions for "{name}" column',
        values: {
          name: item.name
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 354,
        columnNumber: 13
      }
    }),
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    ownFocus: true,
    panelPaddingSize: "none",
    "data-test-subj": "collapsedItemActions",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 352,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: panels,
    className: "actCollapsedItemActions",
    "data-test-subj": "collapsedActionPanel",
    "data-testid": "collapsedActionPanel",
    css: collapsedItemActionsCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 376,
      columnNumber: 11
    }
  })), isUntrackAlertsModalOpen && /*#__PURE__*/_react.default.createElement(_untrack_alerts_modal.UntrackAlertsModal, {
    onCancel: onDisableModalClose,
    onConfirm: onDisable,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 386,
      columnNumber: 11
    }
  }));
};
exports.CollapsedItemActions = CollapsedItemActions;
const CollapsedItemActionsWithApi = exports.CollapsedItemActionsWithApi = (0, _with_bulk_rule_api_operations.withBulkRuleOperations)(CollapsedItemActions);