"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleLastRunOutcomeFilter = void 0;
Object.defineProperty(exports, "getHealthColor", {
  enumerable: true,
  get: function () {
    return _lib.getOutcomeHealthColor;
  }
});
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _common = require("@kbn/alerting-plugin/common");
var _translations = require("../translations");
var _lib = require("../../../../common/lib");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/rules_list/components/rule_last_run_outcome_filter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const sortedRuleLastRunOutcomeValues = [..._common.RuleLastRunOutcomeValues].sort();
const RuleLastRunOutcomeFilter = ({
  selectedOutcomes,
  onChange
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onTogglePopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(prevIsPopoverOpen => !prevIsPopoverOpen);
  }, [setIsPopoverOpen]);
  const onClosePopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(false);
  }, [setIsPopoverOpen]);
  const onFilterSelectItem = (0, _react.useCallback)(filterItem => () => {
    const isPreviouslyChecked = selectedOutcomes.includes(filterItem);
    if (isPreviouslyChecked) {
      onChange === null || onChange === void 0 ? void 0 : onChange(selectedOutcomes.filter(val => val !== filterItem));
    } else {
      onChange === null || onChange === void 0 ? void 0 : onChange(selectedOutcomes.concat(filterItem));
    }
  }, [onChange, selectedOutcomes]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isPopoverOpen,
    closePopover: onClosePopover,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      iconType: "arrowDown",
      isSelected: isPopoverOpen,
      hasActiveFilters: selectedOutcomes.length > 0,
      numActiveFilters: selectedOutcomes.length,
      numFilters: selectedOutcomes.length,
      onClick: onTogglePopover,
      "data-test-subj": "ruleLastRunOutcomeFilterButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.sections.rulesList.ruleLastRunOutcomeFilterLabel",
      defaultMessage: "Last response",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 11
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-yScroll",
    css: {
      maxHeight: euiTheme.base * 30
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }, sortedRuleLastRunOutcomeValues.map(item => {
    const healthColor = (0, _lib.getOutcomeHealthColor)(item, euiTheme);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterSelectItem, {
      key: item,
      style: {
        textTransform: 'capitalize'
      },
      onClick: onFilterSelectItem(item),
      checked: selectedOutcomes.includes(item) ? 'on' : undefined,
      "data-test-subj": `ruleLastRunOutcome${item}FilterOption`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: healthColor,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 15
      }
    }, _translations.rulesLastRunOutcomeTranslationMapping[item]));
  })));
};
exports.RuleLastRunOutcomeFilter = RuleLastRunOutcomeFilter;