"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BaseSnoozePanel = void 0;
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _parse_interval = require("../../../../../../../common/parse_interval");
var _constants = require("./constants");
var _helpers = require("./helpers");
var _translations = require("./translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/rules_list/components/rule_snooze/panel/base_snooze_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const BaseSnoozePanel = ({
  isLoading,
  interval = '3d',
  snoozeRule,
  unsnoozeRule,
  showCancel,
  showAddSchedule = true,
  scheduledSnoozes,
  activeSnoozes,
  navigateToScheduler,
  onRemoveAllSchedules,
  hasTitle,
  inPopover = false
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const [intervalValue, setIntervalValue] = (0, _react.useState)((0, _parse_interval.parseInterval)(interval).value);
  const [intervalUnit, setIntervalUnit] = (0, _react.useState)((0, _parse_interval.parseInterval)(interval).unit);
  const [isRemoveAllModalVisible, setIsRemoveAllModalVisible] = (0, _react.useState)(false);
  const [isCancelModalVisible, setIsCancelModalVisible] = (0, _react.useState)(false);
  const [previousSnoozeInterval, setPreviousSnoozeInterval] = (0, _helpers.usePreviousSnoozeInterval)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const onChangeValue = (0, _react.useCallback)(({
    target
  }) => {
    const value = Number(target.value);
    if (!isNaN(value)) {
      setIntervalValue(value);
    }
  }, [setIntervalValue]);
  const onChangeUnit = (0, _react.useCallback)(({
    target
  }) => setIntervalUnit(target.value), [setIntervalUnit]);
  const snoozeRuleAndStoreInterval = (0, _react.useCallback)((newSnoozeEndTime, intervalToStore) => {
    if (intervalToStore) {
      if (intervalToStore.startsWith('-')) throw new Error('Cannot store a negative interval');
      setPreviousSnoozeInterval(intervalToStore);
    }
    const newSnoozeSchedule = {
      id: null,
      duration: newSnoozeEndTime === -1 ? -1 : Date.parse(newSnoozeEndTime) - Date.now(),
      rRule: {
        dtstart: new Date().toISOString(),
        count: 1,
        tzid: _moment.default.tz.guess()
      }
    };
    return snoozeRule(newSnoozeSchedule);
  }, [setPreviousSnoozeInterval, snoozeRule]);
  const applySnooze = (0, _react.useCallback)(async (value, unit) => {
    if (value === -1) {
      await snoozeRuleAndStoreInterval(-1, null);
    } else if (value !== 0) {
      const newSnoozeEndTime = (0, _moment.default)().add(value, unit).toISOString();
      await snoozeRuleAndStoreInterval(newSnoozeEndTime, `${value}${unit}`);
    } else await unsnoozeRule();
  }, [snoozeRuleAndStoreInterval, unsnoozeRule]);
  const onApplyIndefinite = (0, _react.useCallback)(() => applySnooze(-1), [applySnooze]);
  const onClickApplyButton = (0, _react.useCallback)(() => applySnooze(intervalValue, intervalUnit), [applySnooze, intervalValue, intervalUnit]);
  const onCancelSnooze = (0, _react.useCallback)(() => {
    applySnooze(0, 'm');
    setIsCancelModalVisible(false);
  }, [applySnooze, setIsCancelModalVisible]);
  const onClickCancelSnooze = (0, _react.useCallback)(() => {
    if (activeSnoozes.length === 0) onCancelSnooze();else setIsCancelModalVisible(true);
  }, [activeSnoozes, setIsCancelModalVisible, onCancelSnooze]);
  const onClickAddSchedule = (0, _react.useCallback)(() => navigateToScheduler(), [navigateToScheduler]);
  const onClickEditScheduleFactory = (0, _react.useCallback)(schedule => () => navigateToScheduler(schedule), [navigateToScheduler]);
  const onClickRemoveAllSchedules = (0, _react.useCallback)(() => {
    setIsRemoveAllModalVisible(false);
    onRemoveAllSchedules(scheduledSnoozes.filter(s => s.id).map(s => s.id));
  }, [onRemoveAllSchedules, scheduledSnoozes]);
  const numberOfSchedules = (0, _react.useMemo)(() => {
    if (!scheduledSnoozes) {
      return 0;
    }
    return scheduledSnoozes.filter(s => Boolean(s.id)).length;
  }, [scheduledSnoozes]);
  const hasSchedules = (0, _react.useMemo)(() => numberOfSchedules > 0, [numberOfSchedules]);
  const renderSchedule = () => {
    if (!showAddSchedule) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 167,
        columnNumber: 9
      }
    }), !hasSchedules && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 170,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      color: "primary",
      onClick: onClickAddSchedule,
      "data-test-subj": "ruleAddSchedule",
      iconType: "calendar",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.addSchedule', {
      defaultMessage: 'Add schedule'
    }))))), hasSchedules && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 189,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 190,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxxs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 191,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement("h5", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 192,
        columnNumber: 19
      }
    }, _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.snoozeSchedulesTitle', {
      defaultMessage: 'Schedules'
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 202,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      color: "danger",
      size: "xs",
      onClick: () => setIsRemoveAllModalVisible(true),
      "data-test-subj": "ruleRemoveAllSchedules",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 203,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.removeAllButton', {
      defaultMessage: 'Remove all'
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "xs",
      "data-test-subj": "ruleSchedulesList",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 215,
        columnNumber: 13
      }
    }, scheduledSnoozes.filter(s => s.id).map(schedule => {
      const isActive = schedule.id && activeSnoozes.includes(schedule.id);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: `snooze-${schedule.id}`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 221,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        size: "s",
        onClick: onClickEditScheduleFactory(schedule),
        iconType: isActive ? 'bellSlash' : 'calendar',
        iconSide: "left",
        style: {
          paddingLeft: '9px',
          paddingRight: '9px',
          color: isActive ? euiTheme.colors.textAccent : euiTheme.colors.textSubdued,
          backgroundColor: isActive ? euiTheme.colors.backgroundLightAccent : euiTheme.colors.body
        },
        fullWidth: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 222,
          columnNumber: 23
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 239,
          columnNumber: 25
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 240,
          columnNumber: 27
        }
      }, (0, _helpers.scheduleSummary)(schedule)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 243,
          columnNumber: 27
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "arrowRight",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 244,
          columnNumber: 29
        }
      })))));
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 252,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 253,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      isDisabled: numberOfSchedules >= 5,
      "data-test-subj": "ruleSchedulesListAddButton",
      iconType: "plusInCircleFilled",
      onClick: onClickAddSchedule,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 254,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.addButton', {
      defaultMessage: 'Add'
    }))))));
  };
  const parsedPrevSnooze = previousSnoozeInterval ? (0, _parse_interval.parseInterval)(previousSnoozeInterval) : null;
  const prevSnoozeEqualsCurrentSnooze = (parsedPrevSnooze === null || parsedPrevSnooze === void 0 ? void 0 : parsedPrevSnooze.value) === intervalValue && (parsedPrevSnooze === null || parsedPrevSnooze === void 0 ? void 0 : parsedPrevSnooze.unit) === intervalUnit;
  const previousButton = parsedPrevSnooze && !prevSnoozeEqualsCurrentSnooze && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexStart",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 277,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 278,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    flush: "left",
    size: "s",
    iconType: "refresh",
    "data-test-subj": "ruleSnoozePreviousButton",
    onClick: () => applySnooze(parsedPrevSnooze.value, parsedPrevSnooze.unit),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 279,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.previousSnooze', {
    defaultMessage: 'Previous'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 291,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    "data-test-subj": "ruleSnoozePreviousText",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 292,
      columnNumber: 11
    }
  }, (0, _helpers.durationToTextString)(parsedPrevSnooze.value, parsedPrevSnooze.unit)))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 297,
      columnNumber: 7
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, hasTitle && /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    "data-test-subj": "snoozePanelTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 303,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexStart",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 304,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 305,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "bellSlash",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 306,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 308,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.snoozePanelTitle', {
    defaultMessage: 'Snooze notifications'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexStart",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 314,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 315,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    textAlign: "left",
    size: "xs",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 316,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.addScheduleDescription', {
    defaultMessage: 'Silence actions immediately or schedule downtimes.'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "snoozePanel",
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 328,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 329,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    min: 1,
    value: intervalValue,
    onChange: onChangeValue,
    "aria-label": _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.snoozePanelIntervalValueLabel', {
      defaultMessage: 'Snooze interval value'
    }),
    "data-test-subj": "ruleSnoozeIntervalValue",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 330,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 341,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    id: (0, _eui.useGeneratedHtmlId)({
      prefix: 'snoozeUnit'
    }),
    value: intervalUnit,
    onChange: onChangeUnit,
    "aria-label": _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.snoozePanelIntervalUnitLabel', {
      defaultMessage: 'Snooze interval unit'
    }),
    options: [{
      value: 'm',
      text: _translations.MINUTES
    }, {
      value: 'h',
      text: _translations.HOURS
    }, {
      value: 'd',
      text: _translations.DAYS
    }, {
      value: 'w',
      text: _translations.WEEKS
    }, {
      value: 'M',
      text: _translations.MONTHS
    }],
    "data-test-subj": "ruleSnoozeIntervalUnit",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 342,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 360,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: !intervalValue || intervalValue < 1,
    isLoading: isLoading,
    onClick: onClickApplyButton,
    "data-test-subj": "ruleSnoozeApply",
    minWidth: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 361,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.applySnooze', {
    defaultMessage: 'Apply'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 374,
      columnNumber: 7
    }
  }), previousButton, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2,
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 376,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 377,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 378,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 379,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.snoozeCommonlyUsed', {
    defaultMessage: 'Commonly used'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 386,
      columnNumber: 9
    }
  }), _constants.COMMON_SNOOZE_TIMES.map(([value, unit]) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: `snooze-${value}${unit}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 388,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": `linkSnooze${value}${unit}`,
    onClick: () => applySnooze(value, unit),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 389,
      columnNumber: 13
    }
  }, (0, _helpers.durationToTextString)(value, unit))))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 398,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 399,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 400,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    flush: "left",
    size: "s",
    onClick: onApplyIndefinite,
    "data-test-subj": "ruleSnoozeIndefiniteApply",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 401,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.snoozeIndefinitely', {
    defaultMessage: 'Snooze indefinitely'
  })))), renderSchedule(), showCancel && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !inPopover && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 416,
      columnNumber: 26
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 417,
      columnNumber: 11
    }
  }, !inPopover && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 418,
      columnNumber: 28
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 419,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 420,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isLoading: isLoading,
    color: "danger",
    onClick: onClickCancelSnooze,
    "data-test-subj": "ruleSnoozeCancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 421,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.cancelSnooze', {
    defaultMessage: 'Cancel snooze'
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 436,
      columnNumber: 7
    }
  }), isRemoveAllModalVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    titleProps: {
      id: modalTitleId
    },
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.sections.rulesList.removeAllSnoozeSchedules",
      defaultMessage: "Remove {count, plural, one {schedule} other {# schedules}}?",
      values: {
        count: scheduledSnoozes.filter(s => s.id).length
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 442,
        columnNumber: 13
      }
    }),
    onCancel: () => setIsRemoveAllModalVisible(false),
    onConfirm: onClickRemoveAllSchedules,
    buttonColor: "danger",
    cancelButtonText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.removeCancelButton', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.removeConfirmButton', {
      defaultMessage: 'Remove'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 438,
      columnNumber: 9
    }
  }), isCancelModalVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    titleProps: {
      id: modalTitleId
    },
    title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.cancelSnooze', {
      defaultMessage: 'Cancel snooze'
    }),
    style: {
      maxWidth: '420px'
    },
    onCancel: () => setIsCancelModalVisible(false),
    onConfirm: onCancelSnooze,
    cancelButtonText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.dontApplyCancelSnoozeButton', {
      defaultMessage: "Don't apply"
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.applyCancelSnoozeButton', {
      defaultMessage: 'Apply'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 468,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 490,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.cancelSnoozeConfirmText', {
    defaultMessage: 'Resume notifying when alerts are generated as defined in the rule actions.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 496,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "info",
    size: "s",
    title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.cancelSnoozeConfirmCallout', {
      defaultMessage: 'Only the current occurrence of a schedule will be cancelled.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 497,
      columnNumber: 11
    }
  })));
};
exports.BaseSnoozePanel = BaseSnoozePanel;