"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.SnoozePanel = void 0;
Object.defineProperty(exports, "futureTimeToInterval", {
  enumerable: true,
  get: function () {
    return _helpers.futureTimeToInterval;
  }
});
var _react = _interopRequireWildcard(require("react"));
var _scheduler = require("../scheduler");
var _base_snooze_panel = require("./base_snooze_panel");
var _helpers = require("./helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/rules_list/components/rule_snooze/panel/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SnoozePanel = ({
  interval,
  snoozeRule,
  unsnoozeRule,
  showCancel,
  scheduledSnoozes,
  activeSnoozes,
  hasTitle = true,
  inPopover = false,
  showAddSchedule
}) => {
  const [isSchedulerOpen, setIsSchedulerOpen] = (0, _react.useState)(false);
  const [initialSchedule, setInitialSchedule] = (0, _react.useState)(null);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const onSnoozeRule = (0, _react.useCallback)(async schedule => {
    setIsLoading(true);
    try {
      await snoozeRule(schedule);
    } finally {
      if (!inPopover) {
        setIsLoading(false);
      }
    }
  }, [inPopover, setIsLoading, snoozeRule]);
  const onUnsnoozeRule = (0, _react.useCallback)(async scheduleIds => {
    setIsLoading(true);
    try {
      await unsnoozeRule(scheduleIds);
    } finally {
      if (!inPopover) {
        setIsLoading(false);
      }
    }
  }, [inPopover, setIsLoading, unsnoozeRule]);
  const saveSnoozeSchedule = (0, _react.useCallback)(async schedule => {
    setIsLoading(true);
    try {
      await snoozeRule(schedule);
    } finally {
      if (!inPopover) {
        setIsLoading(false);
      }
    }
  }, [inPopover, snoozeRule, setIsLoading]);
  const cancelSnoozeSchedules = (0, _react.useCallback)(async scheduleIds => {
    setIsLoading(true);
    try {
      await unsnoozeRule(scheduleIds);
    } finally {
      if (!inPopover) {
        setIsLoading(false);
      }
    }
  }, [inPopover, unsnoozeRule, setIsLoading]);
  const onOpenScheduler = (0, _react.useCallback)(schedule => {
    setInitialSchedule(schedule !== null && schedule !== void 0 ? schedule : null);
    setIsSchedulerOpen(true);
  }, [setInitialSchedule, setIsSchedulerOpen]);
  const onCloseScheduler = (0, _react.useCallback)(() => setIsSchedulerOpen(false), [setIsSchedulerOpen]);
  return !isSchedulerOpen ? /*#__PURE__*/_react.default.createElement(_base_snooze_panel.BaseSnoozePanel, {
    isLoading: isLoading,
    snoozeRule: onSnoozeRule,
    unsnoozeRule: onUnsnoozeRule,
    interval: interval,
    showCancel: showCancel,
    showAddSchedule: showAddSchedule,
    scheduledSnoozes: scheduledSnoozes,
    activeSnoozes: activeSnoozes,
    navigateToScheduler: onOpenScheduler,
    onRemoveAllSchedules: cancelSnoozeSchedules,
    hasTitle: hasTitle,
    inPopover: inPopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_scheduler.RuleSnoozeScheduler, {
    isLoading: isLoading,
    initialSchedule: initialSchedule,
    onClose: onCloseScheduler,
    onSaveSchedule: saveSnoozeSchedule,
    onCancelSchedules: cancelSnoozeSchedules,
    hasTitle: hasTitle,
    inPopover: inPopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 5
    }
  });
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.SnoozePanel = SnoozePanel;