"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.recurrenceSummary = exports.rRuleWeekdayToWeekdayName = exports.getWeekdayInfo = exports.getInitialByweekday = exports.generateNthByweekday = exports.buildCustomRecurrenceSchedulerState = void 0;
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _common = require("@kbn/alerting-plugin/common");
var _types = require("../../../../../../types");
var _i18n_month_day_date = require("../../../../../lib/i18n_month_day_date");
var _constants = require("./constants");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getWeekdayInfo = (date, dayOfWeekFmt = 'dddd') => {
  const dayOfWeek = date.format(dayOfWeekFmt);
  const nthWeekdayOfMonth = Math.ceil(date.date() / 7);
  const isLastOfMonth = nthWeekdayOfMonth > 4 || !date.isSame((0, _moment.default)(date).add(7, 'd'), 'month');
  return {
    dayOfWeek,
    nthWeekdayOfMonth,
    isLastOfMonth
  };
};
exports.getWeekdayInfo = getWeekdayInfo;
const getInitialByweekday = (initialStateByweekday, date) => {
  const dayOfWeek = date ? date.isoWeekday() : 1;
  return _common.ISO_WEEKDAYS.reduce((result, n) => ({
    ...result,
    [n]: initialStateByweekday && initialStateByweekday.length > 0 ? initialStateByweekday
    // Sanitize nth day strings, e.g. +2MO, -1FR, into just days of the week
    .map(w => w.replace(/[0-9+\-]/g, '')).includes(_constants.ISO_WEEKDAYS_TO_RRULE[n]) : n === dayOfWeek
  }), {});
};
exports.getInitialByweekday = getInitialByweekday;
const generateNthByweekday = startDate => {
  const {
    isLastOfMonth,
    nthWeekdayOfMonth
  } = getWeekdayInfo(startDate);
  return [`${isLastOfMonth ? '-1' : '+' + nthWeekdayOfMonth}${_constants.ISO_WEEKDAYS_TO_RRULE[startDate.isoWeekday()]}`];
};
exports.generateNthByweekday = generateNthByweekday;
const recurrenceSummary = ({
  freq,
  interval,
  until,
  count,
  byweekday,
  bymonthday,
  bymonth
}) => {
  var _byweekdaySummary;
  const frequencySummary = (0, _translations.i18nFreqSummary)(interval)[freq];

  // For weekday summaries
  const firstWeekday = byweekday ? byweekday[0] : '';
  const nthWeekday = !firstWeekday ? null : firstWeekday.startsWith('+') ? Number(firstWeekday[1]) : firstWeekday.startsWith('-1') ? 0 : null;
  let byweekdaySummary = byweekday && byweekday.length > 0 ? nthWeekday !== null ? (0, _translations.i18nNthWeekdayShort)(rRuleWeekdayToWeekdayName(firstWeekday))[nthWeekday] : _i18n.i18n.translate('xpack.triggersActionsUI.ruleSnoozeScheduler.byweekdaySummary', {
    defaultMessage: 'on {weekdays}',
    values: {
      weekdays: byweekday.map(rRuleWeekday => rRuleWeekdayToWeekdayName(rRuleWeekday)).join(', ')
    }
  }) : null;
  if (byweekdaySummary) byweekdaySummary = byweekdaySummary[0].toLocaleLowerCase() + byweekdaySummary.slice(1);
  const bymonthdaySummary = bymonthday && bymonthday.length > 0 ? _i18n.i18n.translate('xpack.triggersActionsUI.ruleSnoozeScheduler.bymonthdaySummary', {
    defaultMessage: 'on day {monthday}',
    values: {
      monthday: bymonthday.join(', ')
    }
  }) : null;
  const bymonthSummary = bymonth && bymonth.length > 0 && bymonthday && bymonthday.length > 0 ? _i18n.i18n.translate('xpack.triggersActionsUI.ruleSnoozeScheduler.bymonthSummary', {
    defaultMessage: 'on {date}',
    values: {
      date: (0, _i18n_month_day_date.i18nMonthDayDate)((0, _moment.default)().month(bymonth[0] - 1).date(bymonthday[0]))
    }
  }) : null;
  const onSummary = freq === _types.RRuleFrequency.WEEKLY ? byweekdaySummary : freq === _types.RRuleFrequency.MONTHLY ? (_byweekdaySummary = byweekdaySummary) !== null && _byweekdaySummary !== void 0 ? _byweekdaySummary : bymonthdaySummary : freq === _types.RRuleFrequency.YEARLY ? bymonthSummary : null;
  const untilSummary = until ? _i18n.i18n.translate('xpack.triggersActionsUI.ruleSnoozeScheduler.untilDateSummary', {
    defaultMessage: 'until {date}',
    values: {
      date: (0, _moment.default)(until).format('LL')
    }
  }) : count ? _i18n.i18n.translate('xpack.triggersActionsUI.ruleSnoozeScheduler.occurrencesSummary', {
    defaultMessage: 'for {count, plural, one {# occurrence} other {# occurrences}}',
    values: {
      count
    }
  }) : null;
  const every = _i18n.i18n.translate('xpack.triggersActionsUI.ruleSnoozeScheduler.recurrenceSummary', {
    defaultMessage: 'every {frequencySummary}{on}{until}',
    values: {
      frequencySummary,
      on: onSummary ? ` ${onSummary}` : '',
      until: untilSummary ? ` ${untilSummary}` : ''
    }
  });
  return every;
};
exports.recurrenceSummary = recurrenceSummary;
const rRuleWeekdayToWeekdayName = weekday => (0, _moment.default)().isoWeekday(_constants.RRULE_WEEKDAYS_TO_ISO_WEEKDAYS[weekday.slice(-2)]).format('dddd');
exports.rRuleWeekdayToWeekdayName = rRuleWeekdayToWeekdayName;
const buildCustomRecurrenceSchedulerState = ({
  frequency,
  interval,
  byweekday,
  monthlyRecurDay,
  startDate
}) => {
  const isMonthlyByDay = frequency === _types.RRuleFrequency.MONTHLY && monthlyRecurDay === 'day';
  const isMonthlyByWeekday = frequency === _types.RRuleFrequency.MONTHLY && monthlyRecurDay === 'weekday';
  const useByMonthDay = startDate && (isMonthlyByDay || frequency === _types.RRuleFrequency.YEARLY);
  const configuredByweekday =
  // If weekly frequency is selected, pull byweekday from chosen days
  frequency === _types.RRuleFrequency.WEEKLY ? Object.keys(byweekday).filter(k => byweekday[k] === true).map(n => _constants.ISO_WEEKDAYS_TO_RRULE[Number(n)]) :
  // If monthly frequency is selected with the nth weekday option, pull byweekday from the configured startDate
  startDate && isMonthlyByWeekday ? generateNthByweekday(startDate) : [];
  const bymonthday = useByMonthDay ? [startDate.date()] : [];
  const bymonth = startDate && frequency === _types.RRuleFrequency.YEARLY ? [startDate.month() + 1] : [];
  return {
    freq: frequency,
    interval,
    byweekday: configuredByweekday,
    bymonthday,
    bymonth
  };
};
exports.buildCustomRecurrenceSchedulerState = buildCustomRecurrenceSchedulerState;