"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleSnoozeScheduler = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _coreUiSettingsCommon = require("@kbn/core-ui-settings-common");
var _uuid = require("uuid");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _recurrence_scheduler = require("./recurrence_scheduler");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/rules_list/components/rule_snooze/scheduler.tsx",
  _UI_TIMEZONE_OPTIONS$;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TIMEZONE_OPTIONS = (_UI_TIMEZONE_OPTIONS$ = _coreUiSettingsCommon.TIMEZONE_OPTIONS.map(n => ({
  label: n
}))) !== null && _UI_TIMEZONE_OPTIONS$ !== void 0 ? _UI_TIMEZONE_OPTIONS$ : [{
  label: 'UTC'
}];
const useDefaultTimzezone = () => {
  var _moment$tz$guess, _moment$tz;
  const kibanaTz = (0, _public.useUiSetting)('dateFormat:tz');
  if (!kibanaTz || kibanaTz === 'Browser') return (_moment$tz$guess = (_moment$tz = _moment.default.tz) === null || _moment$tz === void 0 ? void 0 : _moment$tz.guess()) !== null && _moment$tz$guess !== void 0 ? _moment$tz$guess : 'UTC';
  return kibanaTz;
};
const ruleSnoozeSchedulerPseudoFocusCss = (0, _react2.css)`
  &:not(:focus) {
    background-image: linear-gradient(to top, #07c, #07c 2px, transparent 2px, transparent 100%);
    background-size: 100% 100%;
    outline: none;
  }
`;
const RuleSnoozeScheduler = ({
  onClose,
  initialSchedule,
  hasTitle = true,
  ...rest
}) => {
  const title = hasTitle && (initialSchedule ? _i18n.i18n.translate('xpack.triggersActionsUI.ruleSnoozeScheduler.editSchedule', {
    defaultMessage: 'Edit schedule'
  }) : _i18n.i18n.translate('xpack.triggersActionsUI.ruleSnoozeScheduler.addSchedule', {
    defaultMessage: 'Add schedule'
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, title && /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexStart",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "arrowLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    color: "text",
    style: {
      fontWeight: 'bold'
    },
    onClick: onClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 15
    }
  }, title)))), /*#__PURE__*/_react.default.createElement(RuleSnoozeSchedulerPanel, (0, _extends2.default)({
    initialSchedule: initialSchedule
  }, rest, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 7
    }
  })));
};
exports.RuleSnoozeScheduler = RuleSnoozeScheduler;
const RuleSnoozeSchedulerPanel = ({
  onSaveSchedule,
  initialSchedule,
  isLoading,
  onCancelSchedules,
  bulkSnoozeSchedule = false,
  showDelete = false,
  inPopover = false
}) => {
  // These two states form a state machine for whether or not the user's clicks on the datepicker apply to the start/end date or start/end time
  // - State A: After the user clicks a start date:
  //    - Next date click will change the end date and move to state B
  //    - Time clicks change the start time, and continue to change the start time until the user clicks an end date
  // - State B: After the user clicks an end date:
  //    - Next date click will change the start date and move to state A
  //    - Time clicks change the end time, and continue to change the end time until the user clicks a start date
  // - State C: If the user clicks on the Start Date textbox:
  //    - Next date click will change the start date and move to state B
  //    - Time clicks change the start time, and continue to change the start time
  // - State D: If the user clicks on the End Date textbox:
  //    - Next date click will change the end date and move to state A
  //    - Time clicks change the end time, and continue to change the end time
  // Component initializes in State C
  const [selectingEndDate, setSelectingEndDate] = (0, _react.useState)(false);
  const [selectingEndTime, setSelectingEndTime] = (0, _react.useState)(false);
  const minDate = (0, _react.useMemo)(
  // If the initial schedule is earlier than now, set minDate to it
  // Set minDate to now if the initial schedule is in the future
  () => {
    var _initialSchedule$rRul;
    return _moment.default.min((0, _moment.default)(), (0, _moment.default)((_initialSchedule$rRul = initialSchedule === null || initialSchedule === void 0 ? void 0 : initialSchedule.rRule.dtstart) !== null && _initialSchedule$rRul !== void 0 ? _initialSchedule$rRul : undefined))
    // Allow the time on minDate to be earlier than the current time
    // This is useful especially when the user is trying to create a recurring schedule
    // that starts today, and should start at a time earlier than the current time on future
    // occurrences
    .hour(0).minute(0);
  }, [initialSchedule]);
  const defaultTz = useDefaultTimzezone();
  const initialState = (0, _react.useMemo)(() => {
    var _initialSchedule$rRul2;
    if (!initialSchedule) {
      return {
        startDT: (0, _moment.default)().add('24', 'h'),
        endDT: (0, _moment.default)().add('48', 'h'),
        isRecurring: false,
        recurrenceSchedule: null,
        selectedTimezone: [{
          label: defaultTz
        }]
      };
    }
    const isRecurring = (initialSchedule === null || initialSchedule === void 0 ? void 0 : (_initialSchedule$rRul2 = initialSchedule.rRule) === null || _initialSchedule$rRul2 === void 0 ? void 0 : _initialSchedule$rRul2.freq) != null;
    const recurrenceSchedule = !isRecurring ? null : {
      ...initialSchedule.rRule,
      ...(initialSchedule.rRule.until ? {
        until: (0, _moment.default)(initialSchedule.rRule.until)
      } : {})
    };

    // Ensure intitial datetimes are displayed in the initial timezone
    const startMoment = (0, _moment.default)(initialSchedule.rRule.dtstart).tz(initialSchedule.rRule.tzid);
    const dtstartOffsetToKibanaTz = (0, _moment.default)().tz(defaultTz).year(startMoment.year()).month(startMoment.month()).date(startMoment.date()).hour(startMoment.hour()).minute(startMoment.minute()).second(startMoment.second()).millisecond(startMoment.millisecond()).toISOString();
    return {
      startDT: (0, _moment.default)(dtstartOffsetToKibanaTz),
      endDT: (0, _moment.default)(dtstartOffsetToKibanaTz).add(initialSchedule.duration, 'ms'),
      isRecurring,
      recurrenceSchedule,
      selectedTimezone: [{
        label: initialSchedule.rRule.tzid
      }]
    };
  }, [initialSchedule, defaultTz]);
  const [startDT, setStartDT] = (0, _react.useState)(initialState.startDT);
  const [endDT, setEndDT] = (0, _react.useState)(initialState.endDT);
  const [isRecurring, setIsRecurring] = (0, _react.useState)(initialState.isRecurring);
  const [recurrenceSchedule, setRecurrenceSchedule] = (0, _react.useState)(initialState.recurrenceSchedule);
  const [selectedTimezone, setSelectedTimezone] = (0, _react.useState)(initialState.selectedTimezone);
  const onFocusStart = (0, _react.useCallback)(() => {
    setSelectingEndDate(false);
    setSelectingEndTime(false);
  }, [setSelectingEndDate]);
  const onFocusEnd = (0, _react.useCallback)(() => {
    setSelectingEndDate(true);
    setSelectingEndTime(true);
  }, [setSelectingEndDate]);
  const selectStartDT = (0, _react.useCallback)((date, clearEndDT) => {
    setStartDT(_moment.default.max(date, minDate));
    if (clearEndDT) {
      setEndDT(null);
      setSelectingEndDate(true);
      setSelectingEndTime(false);
    }
  }, [setStartDT, setSelectingEndDate, minDate]);
  const selectEndDT = (0, _react.useCallback)(date => {
    setEndDT(date.add(1, 'minutes'));
    setSelectingEndTime(true);
    setSelectingEndDate(false);
  }, [setEndDT, setSelectingEndDate]);
  const onSelectFromInline = (0, _react.useCallback)(date => {
    const dateAsMoment = (0, _moment.default)(date);
    const newDateAfterStart = !startDT || dateAsMoment.isSameOrAfter(startDT);
    const isEndDateTimeChange = dateAsMoment.isSame(endDT, 'day') && !dateAsMoment.isSame(endDT, 'minute');
    const isStartDateTimeChange = dateAsMoment.isSame(startDT, 'day') && !dateAsMoment.isSame(startDT, 'minute') && (!isEndDateTimeChange || !selectingEndTime);
    const applyToEndDate = !isStartDateTimeChange && (selectingEndDate || isEndDateTimeChange && selectingEndTime);
    if (applyToEndDate && newDateAfterStart) {
      selectEndDT(date);
    } else selectStartDT(date, !isStartDateTimeChange);
  }, [selectingEndDate, selectingEndTime, startDT, endDT, selectEndDT, selectStartDT]);
  const onClickSaveSchedule = (0, _react.useCallback)(() => {
    var _selectedTimezone$0$l, _initialSchedule$id;
    if (!startDT || !endDT) return;
    const tzid = (_selectedTimezone$0$l = selectedTimezone[0].label) !== null && _selectedTimezone$0$l !== void 0 ? _selectedTimezone$0$l : defaultTz;
    // Convert the dtstart from Kibana timezone to the selected timezone
    const dtstart = (0, _moment.default)().tz(tzid).year(startDT.year()).month(startDT.month()).date(startDT.date()).hour(startDT.hour()).minute(startDT.minute()).second(startDT.second()).toISOString();
    const recurrence = isRecurring && recurrenceSchedule ? recurrenceSchedule : {
      count: 1
    };
    onSaveSchedule({
      id: (_initialSchedule$id = initialSchedule === null || initialSchedule === void 0 ? void 0 : initialSchedule.id) !== null && _initialSchedule$id !== void 0 ? _initialSchedule$id : (0, _uuid.v4)(),
      rRule: {
        dtstart,
        tzid,
        ...recurrence
      },
      duration: endDT.valueOf() - startDT.valueOf()
    });
  }, [onSaveSchedule, endDT, startDT, selectedTimezone, isRecurring, recurrenceSchedule, initialSchedule, defaultTz]);
  const onCancelSchedule = (0, _react.useCallback)(() => {
    if (bulkSnoozeSchedule) {
      onCancelSchedules([]);
    } else if (initialSchedule !== null && initialSchedule !== void 0 && initialSchedule.id) {
      onCancelSchedules([initialSchedule.id]);
    }
  }, [initialSchedule, onCancelSchedules, bulkSnoozeSchedule]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    direction: "column",
    "data-test-subj": "ruleSnoozeScheduler",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 298,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 304,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDatePickerRange, {
    startDateControl: /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, {
      calendarClassName: "hidden",
      preventOpenOnFocus: true,
      showTimeSelect: true,
      onFocus: onFocusStart,
      selected: startDT,
      onChange: setStartDT,
      minDate: minDate,
      isInvalid: startDT === null || startDT === void 0 ? void 0 : startDT.isBefore(minDate),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 307,
        columnNumber: 15
      }
    }),
    endDateControl: /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, {
      calendarClassName: "hidden",
      preventOpenOnFocus: true,
      showTimeSelect: true,
      className: selectingEndDate && !endDT ? 'RuleSnoozeScheduler__pseudofocus' : '',
      css: ruleSnoozeSchedulerPseudoFocusCss,
      onFocus: onFocusEnd,
      selected: endDT,
      onChange: setEndDT,
      minDate: startDT !== null && startDT !== void 0 ? startDT : minDate,
      isInvalid: startDT === null || startDT === void 0 ? void 0 : startDT.isSameOrAfter(endDT),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 319,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 305,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 334,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    hasShadow: false,
    hasBorder: true,
    style: {
      width: '400px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 335,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 336,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, {
    inline: true,
    showTimeSelect: true,
    shadow: false,
    startDate: startDT,
    endDate: endDT,
    selected: selectingEndTime ? endDT : startDT,
    onSelect: onSelectFromInline,
    minDate: minDate,
    adjustDateOnChange: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 337,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 349,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    paddingSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 350,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    style: {
      alignItems: 'center'
    },
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.triggersActionsUI.ruleSnoozeScheduler.timezoneLabel', {
      defaultMessage: 'Timezone'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 351,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    compressed: true,
    singleSelection: {
      asPlainText: true
    },
    options: TIMEZONE_OPTIONS,
    selectedOptions: selectedTimezone,
    onChange: setSelectedTimezone,
    isClearable: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 359,
      columnNumber: 17
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 372,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    compressed: true,
    label: _i18n.i18n.translate('xpack.triggersActionsUI.ruleSnoozeScheduler.repeatSwitch', {
      defaultMessage: 'Repeat'
    }),
    onChange: () => setIsRecurring(!isRecurring),
    checked: isRecurring,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 373,
      columnNumber: 7
    }
  }), isRecurring && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 383,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_recurrence_scheduler.RecurrenceScheduler, {
    startDate: startDT,
    endDate: endDT,
    onChange: setRecurrenceSchedule,
    initialState: recurrenceSchedule,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 384,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 392,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    fullWidth: true,
    disabled: !startDT || !endDT || startDT.isSameOrAfter(endDT) || startDT.isBefore(minDate),
    onClick: onClickSaveSchedule,
    isLoading: isLoading,
    "data-test-subj": "scheduler-saveSchedule",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 393,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.triggersActionsUI.ruleSnoozeScheduler.saveSchedule', {
    defaultMessage: 'Save schedule'
  })), (initialSchedule || showDelete) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !inPopover && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 407,
      columnNumber: 26
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, {
    paddingSize: "m",
    style: /* FIXME https://github.com/elastic/eui/issues/6695 */
    {
      marginBlock: '16px -16px',
      marginInline: '-16px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 408,
      columnNumber: 11
    }
  }, !inPopover && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 418,
      columnNumber: 28
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 419,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 420,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isLoading: isLoading,
    color: "danger",
    onClick: onCancelSchedule,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 421,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.deleteSchedule', {
    defaultMessage: 'Delete schedule'
  })))))));
};