"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.RuleSnoozeModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _kibana = require("../../../../common/lib/kibana");
var _snooze = require("../../../lib/rule_api/snooze");
var _unsnooze = require("../../../lib/rule_api/unsnooze");
var _notify_badge = require("./notify_badge");
var _rule_snooze = require("./rule_snooze");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/rules_list/components/rule_snooze_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const isRuleSnoozed = rule => Boolean(rule.isSnoozedUntil && new Date(rule.isSnoozedUntil).getTime() > Date.now() || rule.muteAll);
const RuleSnoozeModal = ({
  rule,
  onClose,
  onLoading,
  onRuleChanged
}) => {
  var _rule$activeSnoozes, _rule$snoozeSchedule;
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  const isSnoozed = (0, _react.useMemo)(() => {
    return isRuleSnoozed(rule);
  }, [rule]);
  const onApplySnooze = (0, _react.useCallback)(async snoozeSchedule => {
    try {
      onLoading(true);
      onClose();
      await (0, _snooze.snoozeRule)({
        http,
        id: rule.id,
        snoozeSchedule
      });
      onRuleChanged();
      toasts.addSuccess(_notify_badge.SNOOZE_SUCCESS_MESSAGE);
    } catch (e) {
      toasts.addDanger(_notify_badge.SNOOZE_FAILED_MESSAGE);
    } finally {
      onLoading(false);
    }
  }, [onLoading, onClose, http, rule.id, onRuleChanged, toasts]);
  const onApplyUnsnooze = (0, _react.useCallback)(async scheduleIds => {
    try {
      onLoading(true);
      onClose();
      await (0, _unsnooze.unsnoozeRule)({
        http,
        id: rule.id,
        scheduleIds
      });
      onRuleChanged();
      toasts.addSuccess(_notify_badge.UNSNOOZE_SUCCESS_MESSAGE);
    } catch (e) {
      toasts.addDanger(_notify_badge.SNOOZE_FAILED_MESSAGE);
    } finally {
      onLoading(false);
    }
  }, [onLoading, onClose, http, rule.id, onRuleChanged, toasts]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: onClose,
    "data-test-subj": "ruleSnoozeModal",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_rule_snooze.SnoozePanel, {
    inPopover: false,
    interval: (0, _rule_snooze.futureTimeToInterval)(rule.isSnoozedUntil),
    activeSnoozes: (_rule$activeSnoozes = rule.activeSnoozes) !== null && _rule$activeSnoozes !== void 0 ? _rule$activeSnoozes : [],
    scheduledSnoozes: (_rule$snoozeSchedule = rule.snoozeSchedule) !== null && _rule$snoozeSchedule !== void 0 ? _rule$snoozeSchedule : [],
    showCancel: isSnoozed,
    snoozeRule: onApplySnooze,
    unsnoozeRule: onApplyUnsnooze,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 9
    }
  })));
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.RuleSnoozeModal = RuleSnoozeModal;