"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesListAutoRefresh = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/rules_list/components/rules_list_auto_refresh.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const flexGroupStyle = {
  marginLeft: 'auto'
};
const getLastUpdateText = lastUpdate => {
  if (!(0, _moment.default)(lastUpdate).isValid()) {
    return '';
  }
  return _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.rulesListAutoRefresh.lastUpdateText', {
    defaultMessage: 'Updated {lastUpdateText}',
    values: {
      lastUpdateText: (0, _moment.default)(lastUpdate).locale(_i18n.i18n.getLocale()).fromNow()
    }
  });
};
const TEXT_UPDATE_INTERVAL = 60 * 1000;
const DEFAULT_REFRESH_INTERVAL = 5 * 60 * 1000;
const MIN_REFRESH_INTERVAL = 1000;
const RulesListAutoRefresh = props => {
  const {
    lastUpdate,
    initialUpdateInterval = DEFAULT_REFRESH_INTERVAL,
    onRefresh
  } = props;
  const [isPaused, setIsPaused] = (0, _react.useState)(false);
  const [refreshInterval, setRefreshInterval] = (0, _react.useState)(Math.max(initialUpdateInterval, MIN_REFRESH_INTERVAL));
  const [lastUpdateText, setLastUpdateText] = (0, _react.useState)('');
  const cachedOnRefresh = (0, _react.useRef)(() => {});
  const textUpdateTimeout = (0, _react.useRef)();
  const refreshTimeout = (0, _react.useRef)();
  (0, _react.useEffect)(() => {
    cachedOnRefresh.current = onRefresh;
  }, [onRefresh]);
  (0, _react.useEffect)(() => {
    setLastUpdateText(getLastUpdateText(lastUpdate));
    const poll = () => {
      textUpdateTimeout.current = window.setTimeout(() => {
        setLastUpdateText(getLastUpdateText(lastUpdate));
        poll();
      }, TEXT_UPDATE_INTERVAL);
    };
    poll();
    return () => {
      if (textUpdateTimeout.current) {
        clearTimeout(textUpdateTimeout.current);
      }
    };
  }, [lastUpdate, setLastUpdateText]);
  (0, _react.useEffect)(() => {
    if (isPaused) {
      return;
    }
    const poll = () => {
      refreshTimeout.current = window.setTimeout(() => {
        cachedOnRefresh.current();
        poll();
      }, refreshInterval);
    };
    poll();
    return () => {
      if (refreshTimeout.current) {
        clearTimeout(refreshTimeout.current);
      }
    };
  }, [isPaused, refreshInterval]);
  const onRefreshChange = (0, _react.useCallback)(({
    isPaused: newIsPaused,
    refreshInterval: newRefreshInterval
  }) => {
    setIsPaused(newIsPaused);
    setRefreshInterval(newRefreshInterval);
  }, [setIsPaused, setRefreshInterval]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "rulesListAutoRefresh",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: flexGroupStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "rulesListAutoRefresh-lastUpdateText",
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 9
    }
  }, lastUpdateText)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAutoRefreshButton, {
    isPaused: isPaused,
    shortHand: true,
    refreshInterval: refreshInterval,
    onRefreshChange: onRefreshChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 9
    }
  })));
};
exports.RulesListAutoRefresh = RulesListAutoRefresh;