"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.GroupByExpression = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _constants = require("../constants");
var _components = require("./components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/common/expression_items/group_by_over.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const GroupByExpression = ({
  groupBy,
  errors,
  onChangeSelectedTermSize,
  onChangeSelectedTermField,
  onChangeSelectedGroupBy,
  display = 'inline',
  fields,
  termSize,
  termField,
  customGroupByTypes,
  popupPosition,
  canSelectMultiTerms
}) => {
  const groupByTypes = customGroupByTypes !== null && customGroupByTypes !== void 0 ? customGroupByTypes : _constants.builtInGroupByTypes;
  const [groupByPopoverOpen, setGroupByPopoverOpen] = (0, _react.useState)(false);
  const MIN_TERM_SIZE = 1;
  const MAX_TERM_SIZE = 1000;
  const availableFieldOptions = (0, _react.useMemo)(() => (fields !== null && fields !== void 0 ? fields : []).reduce((options, field) => {
    if (groupByTypes[groupBy].validNormalizedTypes.includes(field.normalizedType)) {
      options.push({
        label: field.name
      });
    }
    return options;
  }, []), [groupByTypes, fields, groupBy]);
  const initialTermFieldOptions = (0, _react.useMemo)(() => {
    let initialFields = [];
    if (!!termField) {
      initialFields = Array.isArray(termField) ? termField : [termField];
    }
    return initialFields.map(field => ({
      label: field
    }));
  }, [termField]);
  const [selectedTermsFieldsOptions, setSelectedTermsFieldsOptions] = (0, _react.useState)(initialTermFieldOptions);
  (0, _react.useEffect)(() => {
    if (groupBy === _constants.builtInGroupByTypes.all.value && selectedTermsFieldsOptions.length > 0) {
      setSelectedTermsFieldsOptions([]);
      onChangeSelectedTermField(undefined);
    }
  }, [selectedTermsFieldsOptions, groupBy, onChangeSelectedTermField]);
  (0, _react.useEffect)(() => {
    if (fields && fields.length > 0) {
      // if current field set doesn't contain selected field, clear selection
      const hasUnknownField = selectedTermsFieldsOptions.some(fieldOption => !fields.some(field => field.name === fieldOption.label));
      if (hasUnknownField) {
        setSelectedTermsFieldsOptions([]);
        onChangeSelectedTermField(undefined);
      }
    }
  }, [selectedTermsFieldsOptions, fields, onChangeSelectedTermField]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      description: `${groupByTypes[groupBy].sizeRequired ? _i18n.i18n.translate('xpack.triggersActionsUI.common.expressionItems.groupByType.groupedOverLabel', {
        defaultMessage: 'grouped over'
      }) : _i18n.i18n.translate('xpack.triggersActionsUI.common.expressionItems.groupByType.overLabel', {
        defaultMessage: 'over'
      })}`,
      "data-test-subj": "groupByExpression",
      value: `${groupByTypes[groupBy].text} ${groupByTypes[groupBy].sizeRequired ? `${termSize} ${termField ? `'${termField}'` : ''}` : ''}`,
      isActive: groupByPopoverOpen || groupBy === 'top' && !(termSize && termField),
      onClick: () => {
        setGroupByPopoverOpen(true);
      },
      display: display === 'inline' ? 'inline' : 'columns',
      isInvalid: !(groupBy === 'all' || termSize && termField && termField.length > 0),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 9
      }
    }),
    isOpen: groupByPopoverOpen,
    closePopover: () => {
      setGroupByPopoverOpen(false);
    },
    ownFocus: true,
    display: display === 'fullWidth' ? 'block' : 'inline-block',
    anchorPosition: popupPosition !== null && popupPosition !== void 0 ? popupPosition : 'downRight',
    repositionOnScroll: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_components.ClosablePopoverTitle, {
    onClose: () => setGroupByPopoverOpen(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.common.expressionItems.groupByType.overButtonLabel",
    defaultMessage: "over",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "overExpressionSelect",
    value: groupBy,
    onChange: e => {
      if (groupByTypes[e.target.value].sizeRequired) {
        onChangeSelectedTermSize(MIN_TERM_SIZE);
        onChangeSelectedTermField('');
      } else {
        onChangeSelectedTermSize(undefined);
        onChangeSelectedTermField(undefined);
      }
      onChangeSelectedGroupBy(e.target.value);
    },
    options: Object.values(groupByTypes).map(({
      text,
      value
    }) => {
      return {
        text,
        value
      };
    }),
    "aria-label": _i18n.i18n.translate('xpack.triggersActionsUI.common.expressionItems.groupByType.groupBySelectAriaLabel', {
      defaultMessage: 'Group by'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 13
    }
  })), groupByTypes[groupBy].sizeRequired ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    isInvalid: Number(errors.termSize.length) > 0,
    error: errors.termSize,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "data-test-subj": "fieldsNumberSelect",
    css: (0, _react2.css)`
                      min-width: 50px;
                    `,
    isInvalid: Number(errors.termSize.length) > 0,
    value: termSize || '',
    onChange: e => {
      const {
        value
      } = e.target;
      const termSizeVal = value !== '' ? parseFloat(value) : undefined;
      onChangeSelectedTermSize(termSizeVal);
    },
    min: MIN_TERM_SIZE,
    max: MAX_TERM_SIZE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    isInvalid: Number(errors.termField.length) > 0,
    error: errors.termField,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    singleSelection: canSelectMultiTerms ? false : {
      asPlainText: true
    },
    placeholder: _i18n.i18n.translate('xpack.triggersActionsUI.common.expressionItems.groupByType.timeFieldOptionLabel', {
      defaultMessage: 'Select a field'
    }),
    "data-test-subj": "fieldsExpressionSelect",
    isInvalid: Number(errors.termField.length) > 0,
    selectedOptions: selectedTermsFieldsOptions,
    onChange: selectedOptions => {
      const selectedTermFields = selectedOptions.map(option => option.label);
      const termsToSave = Array.isArray(selectedTermFields) && selectedTermFields.length > 1 ? selectedTermFields : selectedTermFields[0];
      onChangeSelectedTermField(termsToSave);
      setSelectedTermsFieldsOptions(selectedOptions);
    },
    options: availableFieldOptions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 19
    }
  })))) : null)));
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.GroupByExpression = GroupByExpression;