"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.OfExpression = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _constants = require("../constants");
var _components = require("./components");
var _index_controls = require("../index_controls");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/common/expression_items/of.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const OfExpression = ({
  aggType,
  aggField,
  errors,
  onChangeSelectedAggField,
  fields,
  display = 'inline',
  customAggTypesOptions,
  popupPosition,
  helpText
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [aggFieldPopoverOpen, setAggFieldPopoverOpen] = (0, _react.useState)(false);
  const aggregationTypes = customAggTypesOptions !== null && customAggTypesOptions !== void 0 ? customAggTypesOptions : _constants.builtInAggregationTypes;
  const availableFieldOptions = fields.reduce((esFieldOptions, field) => {
    if (aggregationTypes[aggType].validNormalizedTypes.includes(field.normalizedType)) {
      esFieldOptions.push({
        label: field.name
      });
    }
    return esFieldOptions;
  }, []);
  const aggFieldContainerCss = (0, _react2.css)`
    width: calc(${euiTheme.size.base} * 29);
  `;
  (0, _react.useEffect)(() => {
    // if current field set doesn't contain selected field, clear selection
    if (aggField && fields.length > 0 && !fields.find(field => field.name === aggField)) {
      onChangeSelectedAggField(undefined);
    }
  }, [aggField, fields, onChangeSelectedAggField]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "aggFieldPopover",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      description: _i18n.i18n.translate('xpack.triggersActionsUI.common.expressionItems.of.buttonLabel', {
        defaultMessage: 'of'
      }),
      "data-test-subj": "ofExpressionPopover",
      display: display === 'inline' ? 'inline' : 'columns',
      value: aggField || _index_controls.firstFieldOption.text,
      isActive: aggFieldPopoverOpen || !aggField,
      onClick: () => {
        setAggFieldPopoverOpen(true);
      },
      isInvalid: !aggField,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 9
      }
    }),
    isOpen: aggFieldPopoverOpen,
    closePopover: () => {
      setAggFieldPopoverOpen(false);
    },
    display: display === 'fullWidth' ? 'block' : 'inline-block',
    anchorPosition: popupPosition !== null && popupPosition !== void 0 ? popupPosition : 'downRight',
    zIndex: 8000,
    repositionOnScroll: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_components.ClosablePopoverTitle, {
    onClose: () => setAggFieldPopoverOpen(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.common.expressionItems.of.popoverTitle",
    defaultMessage: "of",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "actOf__aggFieldContainer",
    css: aggFieldContainerCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: "ofField",
    fullWidth: true,
    isInvalid: Number(errors.aggField.length) > 0 && aggField !== undefined,
    error: errors.aggField,
    "data-test-subj": "availableFieldsOptionsFormRow",
    helpText: helpText,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    singleSelection: {
      asPlainText: true
    },
    "data-test-subj": "availableFieldsOptionsComboBox",
    isInvalid: Number(errors.aggField.length) > 0 && aggField !== undefined,
    placeholder: _index_controls.firstFieldOption.text,
    options: availableFieldOptions,
    noSuggestions: !availableFieldOptions.length,
    selectedOptions: aggField ? [{
      label: aggField
    }] : [],
    onChange: selectedOptions => {
      onChangeSelectedAggField(selectedOptions.length === 1 ? selectedOptions[0].label : undefined);
      if (selectedOptions.length > 0) {
        setAggFieldPopoverOpen(false);
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 15
    }
  }))))));
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.OfExpression = OfExpression;