"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionFactoryPicker = void 0;
var _react = _interopRequireDefault(require("react"));
var _presentable_picker = require("../presentable_picker");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/ui_actions_enhanced/public/components/action_factory_picker/action_factory_picker.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const ActionFactoryPicker = ({
  actionFactories,
  context,
  onSelect
}) => {
  const items = _react.default.useMemo(() => {
    return actionFactories.map(actionFactory => {
      const item = {
        id: actionFactory.id,
        order: actionFactory.order,
        getDisplayName: ctx => actionFactory.getDisplayName(ctx),
        getIconType: ctx => actionFactory.getIconType(ctx),
        getDisplayNameTooltip: () => '',
        isCompatible: ctx => actionFactory.isCompatible(ctx),
        MenuItem: actionFactory.MenuItem,
        isBeta: actionFactory.isBeta,
        isLicenseCompatible: actionFactory.isCompatibleLicense()
      };
      return item;
    });
  }, [actionFactories]);
  const handleSelect = _react.default.useCallback(id => {
    if (!onSelect) return;
    const actionFactory = actionFactories.find(af => af.id === id);
    if (!actionFactory) return;
    onSelect(actionFactory);
  }, [onSelect, actionFactories]);
  return /*#__PURE__*/_react.default.createElement(_presentable_picker.PresentablePicker, {
    items: items,
    context: context,
    onSelect: handleSelect,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 10
    }
  });
};
exports.ActionFactoryPicker = ActionFactoryPicker;