"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DrilldownTemplateTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("./i18n");
var _text_with_icon = require("../text_with_icon");
var _trigger_line_item = require("../trigger_line_item");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/ui_actions_enhanced/public/drilldowns/drilldown_manager/components/drilldown_template_table/drilldown_template_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DrilldownTemplateTable = ({
  items,
  onCreate,
  onClone
}) => {
  const [selected, setSelected] = (0, _react.useState)([]);
  const columns = [{
    field: 'name',
    name: _i18n.txtNameColumnTitle,
    sortable: true,
    render: (omit, item) => /*#__PURE__*/_react.default.createElement("div", {
      css: {
        display: 'block'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      css: {
        display: 'block'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 11
      }
    }, item.name), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: 'xs',
      color: 'subdued',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 11
      }
    }, item.description))
  }, {
    name: _i18n.txtActionColumnTitle,
    render: item => /*#__PURE__*/_react.default.createElement(_text_with_icon.TextWithIcon, {
      icon: item.actionIcon || 'empty',
      color: 'subdued',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 9
      }
    }, item.actionName)
  }, {
    field: 'trigger',
    name: _i18n.txtTriggerColumnTitle,
    sortable: true,
    render: (omit, item) => /*#__PURE__*/_react.default.createElement(_trigger_line_item.TriggerLineItem, {
      incompatible: item.triggerIncompatible,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 9
      }
    }, item.trigger)
  }, {
    align: 'right',
    render: drilldown => !!onCreate && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      disabled: !!selected.length,
      onClick: () => onCreate(drilldown.id),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 11
      }
    }, _i18n.txtSingleItemCopyActionLabel)
  }];
  const search = {
    box: {
      incremental: true
    },
    defaultQuery: ''
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    itemId: "id",
    tableLayout: "auto",
    items: items,
    columns: columns,
    responsiveBreakpoint: false,
    search: search,
    sorting: {
      sort: {
        field: 'nameCol',
        direction: 'asc'
      }
    },
    selection: {
      onSelectionChange: selection => {
        setSelected(selection.map(drilldown => drilldown.id));
      },
      selectableMessage: () => _i18n.txtSelectableMessage
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 7
    }
  }), !!onClone && !!selected.length && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: () => onClone(selected),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 9
    }
  }, (0, _i18n.txtCopyButtonLabel)(selected.length)));
};
exports.DrilldownTemplateTable = DrilldownTemplateTable;