"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.txtDeleteDrilldownButtonLabel = exports.EditDrilldownForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _context = require("../context");
var _drilldown_form = require("../../components/drilldown_form");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/ui_actions_enhanced/public/drilldowns/drilldown_manager/containers/form_drilldown_wizard/edit_drilldown_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const txtDeleteDrilldownButtonLabel = exports.txtDeleteDrilldownButtonLabel = _i18n.i18n.translate('uiActionsEnhanced.drilldowns.components.flyoutDrilldownWizard.deleteDrilldownButtonLabel', {
  defaultMessage: 'Delete drilldown'
});
const EditDrilldownForm = ({
  state
}) => {
  const drilldowns = (0, _context.useDrilldownManager)();
  const name = state.useName();
  const triggers = state.useTriggers();
  const config = state.useConfig();
  const triggerPickerProps = _react.default.useMemo(() => ({
    items: state.uiTriggers.map(id => {
      const trigger = drilldowns.deps.getTrigger(id);
      return trigger;
    }),
    selected: triggers,
    onChange: state.setTriggers
  }), [drilldowns, triggers, state]);
  const context = state.getFactoryContext();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_drilldown_form.DrilldownForm, {
    name: name,
    onNameChange: state.setName,
    triggers: triggerPickerProps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(state.factory.CollectConfig, {
    config: config,
    onConfig: state.setConfig,
    context: context,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'xl',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => {
      alert('DELETE!');
    },
    color: 'danger',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }, txtDeleteDrilldownButtonLabel));
};
exports.EditDrilldownForm = EditDrilldownForm;