"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UrlDrilldownCollectConfig = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _i18n = require("./i18n");
var _variable_popover = require("../variable_popover");
var _lazy = require("./lazy");
var _constants = require("../../constants");
var _url_validation = require("../../url_validation");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/ui_actions_enhanced/public/drilldowns/url_drilldown/components/url_drilldown_collect_config/url_drilldown_collect_config.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const isCursorBetweenDoubleCurlyBrackets = editor => {
  const model = editor.getModel();
  const position = editor.getPosition();
  if (!model || !position) return false;
  const offset = model.getOffsetAt(position);
  const text = model.getValue();
  const twoCharactersBeforeOffset = text.slice(offset - 2, offset);
  const twoCharactersAfterOffset = text.slice(offset, offset + 2);
  return twoCharactersBeforeOffset === '{{' && twoCharactersAfterOffset === '}}';
};
const UrlDrilldownCollectConfig = ({
  config,
  variables,
  exampleUrl,
  onConfig,
  syntaxHelpDocsLink,
  variablesHelpDocsLink
}) => {
  var _config$url$template;
  const editorRef = (0, _react.useRef)(null);
  const [isPristine, setIsPristine] = _react.default.useState(true);
  const urlTemplate = (_config$url$template = config.url.template) !== null && _config$url$template !== void 0 ? _config$url$template : '';
  function updateUrlTemplate(newUrlTemplate) {
    if (config.url.template !== newUrlTemplate) {
      setIsPristine(false);
      onConfig({
        ...config,
        url: {
          ...config.url,
          template: newUrlTemplate
        }
      });
    }
  }
  const isEmpty = !urlTemplate;
  const isValidUrlFormat = (0, _url_validation.validateUrl)(urlTemplate);
  const isInvalid = !isPristine && (isEmpty || !isValidUrlFormat.isValid);
  const invalidErrorMessage = isInvalid ? isEmpty ? _i18n.txtEmptyErrorMessage : (0, _i18n.txtInvalidFormatErrorMessage)({
    error: isValidUrlFormat.error,
    example: exampleUrl
  }) : undefined;
  const variablesDropdown = /*#__PURE__*/_react.default.createElement(_variable_popover.VariablePopover, {
    variables: variables,
    variablesHelpLink: variablesHelpDocsLink,
    onSelect: variable => {
      const editor = editorRef.current;
      if (!editor) return;
      const text = isCursorBetweenDoubleCurlyBrackets(editor) ? variable : `{{${variable}}}`;
      editor.trigger('keyboard', 'type', {
        text
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    isInvalid: isInvalid,
    error: invalidErrorMessage,
    css: (0, _react2.css)({
      '.euiFormRow__label': {
        alignSelf: 'flex-end'
      }
    }),
    label: _i18n.txtUrlTemplateLabel,
    helpText: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.txtUrlTemplateSyntaxTestingHelpText, ' ', syntaxHelpDocsLink ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      external: true,
      target: '_blank',
      href: syntaxHelpDocsLink,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 15
      }
    }, _i18n.txtUrlTemplateSyntaxHelpLinkText) : null),
    labelAppend: variablesDropdown,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_public.UrlTemplateEditor, {
    fitToContent: {
      minLines: 5,
      maxLines: 15
    },
    variables: variables,
    value: urlTemplate,
    placeholder: exampleUrl,
    onChange: newUrlTemplate => updateUrlTemplate(newUrlTemplate),
    onEditor: editor => {
      editorRef.current = editor;
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'l',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "accordion_url_drilldown_additional_options",
    buttonContent: _i18n.txtUrlTemplateAdditionalOptions,
    "data-test-subj": "urlDrilldownAdditionalOptions",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 's',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    borderRadius: "none",
    hasShadow: false,
    css: {
      border: 'none'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_lazy.UrlDrilldownOptionsComponent, {
    options: {
      ..._constants.DEFAULT_URL_DRILLDOWN_OPTIONS,
      ...config
    },
    onOptionChange: change => {
      onConfig({
        ...config,
        ...change
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 11
    }
  }))));
};
exports.UrlDrilldownCollectConfig = UrlDrilldownCollectConfig;