"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionFactory = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class ActionFactory {
  constructor(def, deps) {
    var _this$def$isBeta;
    (0, _defineProperty2.default)(this, "id", void 0);
    (0, _defineProperty2.default)(this, "isBeta", void 0);
    (0, _defineProperty2.default)(this, "minimalLicense", void 0);
    (0, _defineProperty2.default)(this, "licenseFeatureName", void 0);
    (0, _defineProperty2.default)(this, "order", void 0);
    (0, _defineProperty2.default)(this, "MenuItem", void 0);
    (0, _defineProperty2.default)(this, "CollectConfig", void 0);
    (0, _defineProperty2.default)(this, "createConfig", void 0);
    (0, _defineProperty2.default)(this, "isConfigValid", void 0);
    (0, _defineProperty2.default)(this, "migrations", void 0);
    this.def = def;
    this.deps = deps;
    if (def.minimalLicense && !def.licenseFeatureName) {
      throw new Error(`ActionFactory [actionFactory.id = ${def.id}] "licenseFeatureName" is required, if "minimalLicense" is provided`);
    }
    this.id = this.def.id;
    this.isBeta = (_this$def$isBeta = this.def.isBeta) !== null && _this$def$isBeta !== void 0 ? _this$def$isBeta : false;
    this.minimalLicense = this.def.minimalLicense;
    this.licenseFeatureName = this.def.licenseFeatureName;
    this.order = this.def.order || 0;
    this.MenuItem = this.def.MenuItem;
    this.CollectConfig = this.def.CollectConfig;
    this.createConfig = this.def.createConfig;
    this.isConfigValid = this.def.isConfigValid;
    this.migrations = this.def.migrations || {};
  }
  getIconType(context) {
    if (!this.def.getIconType) return undefined;
    return this.def.getIconType(context);
  }
  getDisplayName(context) {
    if (!this.def.getDisplayName) return '';
    return this.def.getDisplayName(context);
  }
  getDisplayNameTooltip(context) {
    return '';
  }
  async isCompatible(context) {
    if (!this.def.isCompatible) return true;
    return await this.def.isCompatible(context);
  }

  /**
   * Does this action factory license requirements
   * compatible with current license?
   */
  isCompatibleLicense() {
    if (!this.minimalLicense || !this.deps.getLicense) return true;
    const license = this.deps.getLicense();
    return license.isAvailable && license.isActive && license.hasAtLeast(this.minimalLicense);
  }
  create(serializedAction) {
    const action = this.def.create(serializedAction);
    return {
      ...action,
      isCompatible: async context => {
        if (!this.isCompatibleLicense()) return false;
        if (!action.isCompatible) return true;
        return action.isCompatible(context);
      },
      execute: async context => {
        this.notifyFeatureUsage();
        return action.execute(context);
      }
    };
  }
  supportedTriggers() {
    return this.def.supportedTriggers();
  }
  notifyFeatureUsage() {
    if (!this.minimalLicense || !this.licenseFeatureName || !this.deps.getFeatureUsageStart) return;
    const featureUsageStart = this.deps.getFeatureUsageStart();
    if (featureUsageStart) {
      featureUsageStart.notifyUsage(this.licenseFeatureName).catch(() => {
        // eslint-disable-next-line no-console
        console.warn(`ActionFactory [actionFactory.id = ${this.def.id}] fail notify feature usage.`);
      });
    }
  }
  telemetry(state, telemetryData) {
    return this.def.telemetry ? this.def.telemetry(state, telemetryData) : telemetryData;
  }
  extract(state) {
    return this.def.extract ? this.def.extract(state) : {
      state,
      references: []
    };
  }
  inject(state, references) {
    return this.def.inject ? this.def.inject(state, references) : state;
  }
}
exports.ActionFactory = ActionFactory;