"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedUiActionsServerPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _dynamic_action_enhancement = require("./dynamic_action_enhancement");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// eslint-disable-next-line @typescript-eslint/no-empty-interface

class AdvancedUiActionsServerPlugin {
  constructor() {
    (0, _defineProperty2.default)(this, "actionFactories", new Map());
    /**
     * Register an action factory. Action factories are used to configure and
     * serialize/deserialize dynamic actions.
     */
    (0, _defineProperty2.default)(this, "registerActionFactory", definition => {
      if (this.actionFactories.has(definition.id)) {
        throw new Error(`ActionFactory [actionFactory.id = ${definition.id}] already registered.`);
      }
      this.actionFactories.set(definition.id, {
        id: definition.id,
        telemetry: definition.telemetry || ((state, stats) => stats),
        inject: definition.inject || _lodash.identity,
        extract: definition.extract || (state => {
          return {
            state,
            references: []
          };
        }),
        migrations: definition.migrations || {}
      });
    });
  }
  setup(_core, {
    embeddable
  }) {
    const getActionFactory = actionFactoryId => this.actionFactories.get(actionFactoryId);
    embeddable.registerEnhancement((0, _dynamic_action_enhancement.dynamicActionEnhancement)(getActionFactory));
    return {
      registerActionFactory: this.registerActionFactory
    };
  }
  start() {}
  stop() {}
}
exports.AdvancedUiActionsServerPlugin = AdvancedUiActionsServerPlugin;