"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFlyoutA11y = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _useUnmount = _interopRequireDefault(require("react-use/lib/useUnmount"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_doc_viewer/public/components/doc_viewer_flyout/use_flyout_a11y.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useFlyoutA11y = ({
  isXlScreen
}) => {
  const descriptionId = (0, _eui.useGeneratedHtmlId)();
  const [triggerEl] = (0, _react.useState)(document.activeElement);
  const [flyoutEl, setFlyoutEl] = (0, _react.useState)();

  // Auto-focus push flyout on open or when switching to XL screen
  (0, _react.useEffect)(() => {
    if (isXlScreen && flyoutEl && document.contains(flyoutEl)) {
      // Wait a tick before focusing or focus will be stolen by the trigger element when
      // switching from an overlay flyout to a push flyout (due to EUI focus lock)
      setTimeout(() => flyoutEl.focus());
    }
  }, [flyoutEl, isXlScreen]);

  // Return focus to the trigger element when the flyout is closed
  (0, _useUnmount.default)(() => {
    if (triggerEl instanceof HTMLElement && document.contains(triggerEl)) {
      triggerEl.focus();
    }
  });
  return {
    a11yProps: {
      ref: setFlyoutEl,
      role: isXlScreen ? 'dialog' : undefined,
      tabIndex: isXlScreen ? 0 : undefined,
      'aria-describedby': isXlScreen ? descriptionId : undefined,
      'data-no-focus-lock': isXlScreen || undefined
    },
    screenReaderDescription: isXlScreen && /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      id: descriptionId,
      "data-test-subj": "unifiedDocViewerScreenReaderDescription",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('unifiedDocViewer.flyout.screenReaderDescription', {
      defaultMessage: 'You are in a non-modal dialog. To close the dialog, press Escape.'
    })))
  };
};
exports.useFlyoutA11y = useFlyoutA11y;