"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFieldCellActions = getFieldCellActions;
exports.getFieldValueCellActions = getFieldValueCellActions;
exports.getFilterExistsDisabledWarning = getFilterExistsDisabledWarning;
exports.getFilterInOutPairDisabledWarning = getFilterInOutPairDisabledWarning;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_doc_viewer/public/components/doc_viewer_table/table_cell_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function isFilterInOutPairDisabled(row, onFilter) {
  if (!row) {
    return false;
  }
  const {
    dataViewField,
    ignoredReason
  } = row;
  return Boolean(onFilter && (!dataViewField || !dataViewField.filterable || ignoredReason));
}
function getFilterInOutPairDisabledWarning(row, onFilter) {
  if (!row || !isFilterInOutPairDisabled(row, onFilter)) {
    return undefined;
  }
  const {
    dataViewField,
    ignoredReason
  } = row;
  if (ignoredReason) {
    return _i18n.i18n.translate('unifiedDocViewer.docViews.table.ignoredValuesCanNotBeSearchedWarningMessage', {
      defaultMessage: 'Ignored values cannot be searched'
    });
  }
  return !dataViewField ? _i18n.i18n.translate('unifiedDocViewer.docViews.table.unindexedFieldsCanNotBeSearchedWarningMessage', {
    defaultMessage: 'Unindexed fields cannot be searched'
  }) : undefined;
}
const esqlMultivalueFilteringDisabled = _i18n.i18n.translate('unifiedDocViewer.docViews.table.esqlMultivalueFilteringDisabled', {
  defaultMessage: 'Multivalue filtering is not supported in ES|QL'
});
const Copy = ({
  Component,
  row,
  toasts
}) => {
  if (!row) {
    return null;
  }
  const {
    name
  } = row;
  const copyLabel = _i18n.i18n.translate('unifiedDocViewer.docViews.table.copyValue', {
    defaultMessage: 'Copy value'
  });
  return /*#__PURE__*/_react.default.createElement(Component, {
    "data-test-subj": `copyValueButton-${name}`,
    iconType: "copyClipboard",
    title: copyLabel,
    flush: "left",
    onClick: () => {
      const errorMessage = _i18n.i18n.translate('unifiedDocViewer.tableCellActions.copyFailedErrorText', {
        defaultMessage: 'Unable to copy to clipboard in this browser'
      });
      if (!row.formattedAsText) {
        toasts.addWarning({
          title: errorMessage
        });
        return;
      }
      const copied = (0, _eui.copyToClipboard)(row.formattedAsText);
      if (!copied) {
        toasts.addWarning({
          title: errorMessage
        });
        return;
      }
      toasts.addInfo({
        title: _i18n.i18n.translate('unifiedDocViewer.tableCellActions.copyValueToClipboard.toastTitle', {
          defaultMessage: 'Copied to clipboard'
        })
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 5
    }
  }, copyLabel);
};
const FilterIn = ({
  Component,
  row,
  isEsqlMode,
  onFilter
}) => {
  if (!row) {
    return null;
  }
  const {
    dataViewField,
    name,
    flattenedValue
  } = row;

  // Filters pair
  const filterAddLabel = _i18n.i18n.translate('unifiedDocViewer.docViews.table.filterForValueButtonTooltip', {
    defaultMessage: 'Filter for value'
  });
  if (!onFilter) {
    return null;
  }
  const filteringDisabled = isEsqlMode && Array.isArray(flattenedValue);
  return /*#__PURE__*/_react.default.createElement(Component, {
    "data-test-subj": `addFilterForValueButton-${name}`,
    iconType: "plusInCircle",
    disabled: filteringDisabled || isFilterInOutPairDisabled(row, onFilter),
    title: filteringDisabled ? esqlMultivalueFilteringDisabled : filterAddLabel,
    flush: "left",
    onClick: () => onFilter(dataViewField, flattenedValue, '+'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 5
    }
  }, filterAddLabel);
};
const FilterOut = ({
  Component,
  row,
  isEsqlMode,
  onFilter
}) => {
  if (!row) {
    return null;
  }
  const {
    dataViewField,
    name,
    flattenedValue
  } = row;

  // Filters pair
  const filterOutLabel = _i18n.i18n.translate('unifiedDocViewer.docViews.table.filterOutValueButtonTooltip', {
    defaultMessage: 'Filter out value'
  });
  if (!onFilter) {
    return null;
  }
  const filteringDisabled = isEsqlMode && Array.isArray(flattenedValue);
  return /*#__PURE__*/_react.default.createElement(Component, {
    "data-test-subj": `addFilterOutValueButton-${name}`,
    iconType: "minusInCircle",
    disabled: filteringDisabled || isFilterInOutPairDisabled(row, onFilter),
    title: filteringDisabled ? esqlMultivalueFilteringDisabled : filterOutLabel,
    flush: "left",
    onClick: () => onFilter(dataViewField, flattenedValue, '-'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 5
    }
  }, filterOutLabel);
};
function isFilterExistsDisabled(row, onFilter) {
  if (!row) {
    return false;
  }
  const {
    dataViewField
  } = row;
  return Boolean(onFilter && (!dataViewField || !dataViewField.filterable || dataViewField.scripted));
}
function getFilterExistsDisabledWarning(row, onFilter) {
  if (!row || !isFilterExistsDisabled(row, onFilter)) {
    return undefined;
  }
  const {
    dataViewField
  } = row;
  return dataViewField !== null && dataViewField !== void 0 && dataViewField.scripted ? _i18n.i18n.translate('unifiedDocViewer.docViews.table.unableToFilterForPresenceOfScriptedFieldsWarningMessage', {
    defaultMessage: 'Unable to filter for presence of scripted fields'
  }) : undefined;
}
const FilterExist = ({
  Component,
  row,
  onFilter
}) => {
  if (!row) {
    return null;
  }
  const {
    name
  } = row;

  // Filter exists
  const filterExistsLabel = _i18n.i18n.translate('unifiedDocViewer.docViews.table.filterForFieldPresentButtonTooltip', {
    defaultMessage: 'Filter for field present'
  });
  if (!onFilter) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(Component, {
    "data-test-subj": `addExistsFilterButton-${name}`,
    iconType: "filter",
    disabled: isFilterExistsDisabled(row, onFilter),
    title: filterExistsLabel,
    flush: "left",
    onClick: () => onFilter('_exists_', name, '+'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 265,
      columnNumber: 5
    }
  }, filterExistsLabel);
};
const ToggleColumn = ({
  Component,
  row,
  onToggleColumn
}) => {
  if (!row) {
    return null;
  }
  const {
    name
  } = row;
  if (!onToggleColumn) {
    return null;
  }

  // Toggle column
  const toggleColumnLabel = _i18n.i18n.translate('unifiedDocViewer.docViews.table.toggleColumnTableButtonTooltip', {
    defaultMessage: 'Toggle column in table'
  });
  return /*#__PURE__*/_react.default.createElement(Component, {
    "data-test-subj": `toggleColumnButton-${name}`,
    iconType: "listAdd",
    title: toggleColumnLabel,
    flush: "left",
    onClick: () => onToggleColumn(name),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 302,
      columnNumber: 5
    }
  }, toggleColumnLabel);
};
function getFieldCellActions({
  rows,
  isEsqlMode,
  onFilter,
  onToggleColumn
}) {
  return [...(onFilter ? [({
    Component,
    rowIndex
  }) => {
    return /*#__PURE__*/_react.default.createElement(FilterExist, {
      row: rows[rowIndex],
      Component: Component,
      isEsqlMode: isEsqlMode,
      onFilter: onFilter,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 330,
        columnNumber: 15
      }
    });
  }] : []), ...(onToggleColumn ? [({
    Component,
    rowIndex
  }) => {
    return /*#__PURE__*/_react.default.createElement(ToggleColumn, {
      row: rows[rowIndex],
      Component: Component,
      isEsqlMode: isEsqlMode,
      onToggleColumn: onToggleColumn,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 344,
        columnNumber: 15
      }
    });
  }] : [])];
}
function getFieldValueCellActions({
  rows,
  isEsqlMode,
  onFilter,
  toasts
}) {
  const filterActions = onFilter ? [({
    Component,
    rowIndex
  }) => {
    return /*#__PURE__*/_react.default.createElement(FilterIn, {
      row: rows[rowIndex],
      Component: Component,
      isEsqlMode: isEsqlMode,
      onFilter: onFilter,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 372,
        columnNumber: 13
      }
    });
  }, ({
    Component,
    rowIndex
  }) => {
    return /*#__PURE__*/_react.default.createElement(FilterOut, {
      row: rows[rowIndex],
      Component: Component,
      isEsqlMode: isEsqlMode,
      onFilter: onFilter,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 382,
        columnNumber: 13
      }
    });
  }] : [];
  const copyAction = ({
    Component,
    rowIndex
  }) => {
    return /*#__PURE__*/_react.default.createElement(Copy, {
      toasts: toasts,
      row: rows[rowIndex],
      Component: Component,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 394,
        columnNumber: 12
      }
    });
  };
  return [...filterActions, copyAction];
}