"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTableFilters = exports.TermMatch = exports.TableFilters = exports.LOCAL_STORAGE_KEY_SELECTED_FIELD_TYPES = exports.LOCAL_STORAGE_KEY_SEARCH_TERM = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _fieldUtils = require("@kbn/field-utils");
var _field_type_filter = require("@kbn/unified-field-list/src/components/field_list_filters/field_type_filter");
var _plugin = require("../../plugin");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_doc_viewer/public/components/doc_viewer_table/table_filters.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LOCAL_STORAGE_KEY_SEARCH_TERM = exports.LOCAL_STORAGE_KEY_SEARCH_TERM = 'discover:searchText';
const LOCAL_STORAGE_KEY_SELECTED_FIELD_TYPES = exports.LOCAL_STORAGE_KEY_SELECTED_FIELD_TYPES = 'unifiedDocViewer:selectedFieldTypes';
let TermMatch = exports.TermMatch = /*#__PURE__*/function (TermMatch) {
  TermMatch["name"] = "name";
  TermMatch["value"] = "value";
  TermMatch["both"] = "both";
  return TermMatch;
}({});
const TableFilters = ({
  searchTerm,
  onChangeSearchTerm,
  selectedFieldTypes,
  onChangeFieldTypes,
  allFields
}) => {
  const {
    core
  } = (0, _plugin.getUnifiedDocViewerServices)();
  const onSearchTermChange = (0, _react.useCallback)(event => {
    const newSearchTerm = event.currentTarget.value;
    onChangeSearchTerm(newSearchTerm);
  }, [onChangeSearchTerm]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "data-test-subj": "unifiedDocViewerFieldsSearchInput",
    "aria-label": _i18n.i18n.translate('unifiedDocViewer.docView.table.searchAriaLabel', {
      defaultMessage: 'Field name or value'
    }),
    placeholder: _i18n.i18n.translate('unifiedDocViewer.docView.table.searchPlaceHolder', {
      defaultMessage: 'Search field names or values'
    }),
    fullWidth: true,
    compressed: true,
    value: searchTerm,
    onChange: onSearchTermChange,
    append: allFields && selectedFieldTypes && onChangeFieldTypes ? /*#__PURE__*/_react.default.createElement(_field_type_filter.FieldTypeFilter, {
      "data-test-subj": "unifiedDocViewerFieldsTable",
      docLinks: core.docLinks,
      selectedFieldTypes: selectedFieldTypes,
      allFields: allFields,
      onChange: onChangeFieldTypes,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 11
      }
    }) : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 5
    }
  });
};
exports.TableFilters = TableFilters;
const persistSearchTerm = (0, _lodash.debounce)((newSearchText, storage) => storage.set(LOCAL_STORAGE_KEY_SEARCH_TERM, newSearchText), 500, {
  leading: true,
  trailing: true
});
const persistSelectedFieldTypes = (0, _lodash.debounce)((selectedFieldTypes, storage) => storage.set(LOCAL_STORAGE_KEY_SELECTED_FIELD_TYPES, JSON.stringify(selectedFieldTypes)), 500, {
  leading: true,
  trailing: true
});
const getStoredFieldTypes = storage => {
  const storedFieldTypes = storage.get(LOCAL_STORAGE_KEY_SELECTED_FIELD_TYPES);
  let parsedFieldTypes = [];
  try {
    parsedFieldTypes = storedFieldTypes ? JSON.parse(storedFieldTypes) : [];
  } catch {
    // ignore invalid JSON
  }
  return Array.isArray(parsedFieldTypes) ? parsedFieldTypes : [];
};
const useTableFilters = ({
  storage,
  storageKey
}) => {
  const [searchTerm, setSearchTerm] = (0, _react.useState)(storage.get(storageKey) || '');
  const [selectedFieldTypes, setSelectedFieldTypes] = (0, _react.useState)(getStoredFieldTypes(storage));
  const onChangeSearchTerm = (0, _react.useCallback)(newSearchTerm => {
    setSearchTerm(newSearchTerm);
    persistSearchTerm(newSearchTerm, storage);
  }, [storage, setSearchTerm]);
  const onChangeFieldTypes = (0, _react.useCallback)(newFieldTypes => {
    setSelectedFieldTypes(newFieldTypes);
    persistSelectedFieldTypes(newFieldTypes, storage);
  }, [storage, setSelectedFieldTypes]);
  const onFindSearchTermMatch = (0, _react.useCallback)((row, term) => {
    const {
      name,
      dataViewField
    } = row;
    let termMatch = null;
    if ((0, _fieldUtils.fieldNameWildcardMatcher)({
      name,
      displayName: dataViewField === null || dataViewField === void 0 ? void 0 : dataViewField.customLabel
    }, term)) {
      termMatch = TermMatch.name;
    }
    if ((row.formattedAsText || '').toLowerCase().includes(term.toLowerCase()) || (JSON.stringify(row.flattenedValue) || '').toLowerCase().includes(term.toLowerCase())) {
      termMatch = termMatch ? TermMatch.both : TermMatch.value;
    }
    return termMatch;
  }, []);
  const onFilterField = (0, _react.useCallback)(row => {
    const {
      fieldType
    } = row;
    const term = searchTerm === null || searchTerm === void 0 ? void 0 : searchTerm.trim();
    if (term && !onFindSearchTermMatch(row, term)) {
      return false;
    }
    if (selectedFieldTypes.length > 0 && fieldType) {
      return selectedFieldTypes.includes(fieldType);
    }
    return true;
  }, [searchTerm, selectedFieldTypes, onFindSearchTermMatch]);
  return (0, _react.useMemo)(() => ({
    // props for TableFilters component
    searchTerm,
    onChangeSearchTerm,
    selectedFieldTypes,
    onChangeFieldTypes,
    // the actual filtering function
    onFilterField,
    onFindSearchTermMatch
  }), [searchTerm, onChangeSearchTerm, selectedFieldTypes, onChangeFieldTypes, onFilterField, onFindSearchTermMatch]);
};
exports.useTableFilters = useTableFilters;