"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PAGE_SIZE_OPTIONS = exports.GRID_COLUMN_FIELD_VALUE = exports.GRID_COLUMN_FIELD_NAME = void 0;
exports.TableGrid = TableGrid;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _discoverUtils = require("@kbn/discover-utils");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireWildcard(require("react"));
var _plugin = require("../../plugin");
var _get_pin_control = require("./get_pin_control");
var _table_cell = require("./table_cell");
var _table_cell_actions = require("./table_cell_actions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_doc_viewer/public/components/doc_viewer_table/table_grid.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getGridProps(gridStyle) {
  return {
    columnVisibility: {
      visibleColumns: ['name', 'value'],
      setVisibleColumns: () => null
    },
    rowHeightsOptions: {
      defaultHeight: 'auto'
    },
    gridStyle: {
      border: 'horizontal',
      stripes: true,
      rowHover: 'highlight',
      header: 'underline',
      cellPadding: 'm',
      fontSize: 's',
      ...(gridStyle !== null && gridStyle !== void 0 ? gridStyle : {})
    }
  };
}
const MIN_NAME_COLUMN_WIDTH = 150;
const MAX_NAME_COLUMN_WIDTH = 350;
const PAGE_SIZE_OPTIONS = exports.PAGE_SIZE_OPTIONS = [25, 50, 100, 250, 500];
const GRID_COLUMN_FIELD_NAME = exports.GRID_COLUMN_FIELD_NAME = 'name';
const GRID_COLUMN_FIELD_VALUE = exports.GRID_COLUMN_FIELD_VALUE = 'value';
function TableGrid({
  id,
  containerWidth,
  rows,
  isEsqlMode,
  filter,
  onAddColumn,
  onRemoveColumn,
  columns,
  onFindSearchTermMatch,
  searchTerm,
  initialPageSize,
  onChangePageSize,
  onTogglePinned,
  hidePinColumn = false,
  customRenderCellValue,
  customRenderCellPopover,
  gridStyle
}) {
  const styles = (0, _use_memo_css.useMemoCss)(componentStyles);
  const {
    toasts
  } = (0, _plugin.getUnifiedDocViewerServices)();
  const onToggleColumn = (0, _react2.useMemo)(() => {
    if (!onRemoveColumn || !onAddColumn || !columns) {
      return undefined;
    }
    return field => {
      if (columns.includes(field)) {
        onRemoveColumn(field);
      } else {
        onAddColumn(field);
      }
    };
  }, [onRemoveColumn, onAddColumn, columns]);
  const fieldCellActions = (0, _react2.useMemo)(() => (0, _table_cell_actions.getFieldCellActions)({
    rows,
    isEsqlMode,
    onFilter: filter,
    onToggleColumn
  }), [rows, isEsqlMode, filter, onToggleColumn]);
  const fieldValueCellActions = (0, _react2.useMemo)(() => (0, _table_cell_actions.getFieldValueCellActions)({
    rows,
    isEsqlMode,
    toasts,
    onFilter: filter
  }), [rows, isEsqlMode, toasts, filter]);
  const {
    curPageIndex,
    pageSize,
    totalPages,
    changePageIndex,
    changePageSize
  } = (0, _discoverUtils.usePager)({
    initialPageSize,
    totalItems: rows.length
  });
  const handleChangePageSize = (0, _react2.useCallback)(newPageSize => {
    onChangePageSize === null || onChangePageSize === void 0 ? void 0 : onChangePageSize(newPageSize);
    changePageSize(newPageSize);
  }, [changePageSize, onChangePageSize]);
  const showPagination = totalPages !== 0;
  const pagination = (0, _react2.useMemo)(() => {
    return showPagination ? {
      onChangeItemsPerPage: handleChangePageSize,
      onChangePage: changePageIndex,
      pageIndex: curPageIndex,
      pageSize,
      pageSizeOptions: PAGE_SIZE_OPTIONS
    } : undefined;
  }, [showPagination, handleChangePageSize, changePageIndex, curPageIndex, pageSize]);
  const gridColumns = (0, _react2.useMemo)(() => [{
    id: GRID_COLUMN_FIELD_NAME,
    displayAsText: _i18n.i18n.translate('unifiedDocViewer.fieldChooser.discoverField.name', {
      defaultMessage: 'Field'
    }),
    initialWidth: Math.min(Math.max(Math.round(containerWidth * 0.3), MIN_NAME_COLUMN_WIDTH), MAX_NAME_COLUMN_WIDTH),
    actions: false,
    visibleCellActions: 3,
    cellActions: fieldCellActions
  }, {
    id: GRID_COLUMN_FIELD_VALUE,
    displayAsText: _i18n.i18n.translate('unifiedDocViewer.fieldChooser.discoverField.value', {
      defaultMessage: 'Value'
    }),
    actions: false,
    visibleCellActions: 3,
    cellActions: fieldValueCellActions
  }], [fieldCellActions, fieldValueCellActions, containerWidth]);
  const renderCellValue = (0, _react2.useCallback)(({
    rowIndex,
    columnId,
    isDetails
  }) => {
    return /*#__PURE__*/_react2.default.createElement(_table_cell.TableCell, {
      searchTerm: searchTerm || '',
      rows: rows,
      rowIndex: rowIndex,
      columnId: columnId,
      isDetails: isDetails,
      onFindSearchTermMatch: onFindSearchTermMatch,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 187,
        columnNumber: 9
      }
    });
  }, [searchTerm, rows, onFindSearchTermMatch]);
  const renderCellPopover = (0, _react2.useCallback)(props => {
    const {
      columnId,
      children,
      cellActions,
      rowIndex
    } = props;
    const row = rows[rowIndex];
    let warningMessage;
    if (columnId === GRID_COLUMN_FIELD_VALUE) {
      warningMessage = (0, _table_cell_actions.getFilterInOutPairDisabledWarning)(row, filter);
    } else if (columnId === GRID_COLUMN_FIELD_NAME) {
      warningMessage = (0, _table_cell_actions.getFilterExistsDisabledWarning)(row, filter);
    }
    return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 214,
        columnNumber: 11
      }
    }, children), cellActions, Boolean(warningMessage) && /*#__PURE__*/_react2.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 217,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 218,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react2.default.createElement(_eui.EuiCallOut, {
      title: warningMessage,
      color: "warning",
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 219,
        columnNumber: 15
      }
    })));
  }, [rows, filter]);
  const leadingControlColumns = (0, _react2.useMemo)(() => {
    return onTogglePinned && !hidePinColumn ? [(0, _get_pin_control.getPinColumnControl)({
      rows,
      onTogglePinned
    })] : [];
  }, [onTogglePinned, hidePinColumn, rows]);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiDataGrid, (0, _extends2.default)({
    key: `fields-table-${id}`,
    "data-test-subj": "UnifiedDocViewerTableGrid"
  }, getGridProps(gridStyle), {
    "aria-label": _i18n.i18n.translate('unifiedDocViewer.fieldsTable.ariaLabel', {
      defaultMessage: 'Field values'
    }),
    className: "kbnDocViewer__fieldsGrid",
    css: styles.fieldsGrid,
    columns: gridColumns,
    toolbarVisibility: false,
    rowCount: rows.length,
    renderCellValue: customRenderCellValue ? customRenderCellValue : renderCellValue,
    renderCellPopover: customRenderCellPopover ? customRenderCellPopover : renderCellPopover,
    pagination: pagination,
    leadingControlColumns: leadingControlColumns,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 5
    }
  }));
}
const componentStyles = {
  fieldsGrid: themeContext => {
    const {
      euiTheme
    } = themeContext;
    const {
      fontSize
    } = (0, _eui.euiFontSize)(themeContext, 's');
    return (0, _react.css)({
      '&.euiDataGrid--noControls.euiDataGrid--bordersHorizontal .euiDataGridHeader': {
        borderTop: 'none'
      },
      '&.euiDataGrid--headerUnderline .euiDataGridHeader': {
        borderBottom: euiTheme.border.thin
      },
      '& [data-gridcell-column-id="name"] .euiDataGridRowCell__content': {
        paddingTop: 0,
        paddingBottom: 0
      },
      '& [data-gridcell-column-id="pin_field"] .euiDataGridRowCell__content': {
        padding: `calc(${euiTheme.size.xs} / 2) 0 0 ${euiTheme.size.xs}`
      },
      '.kbnDocViewer__fieldName': {
        padding: euiTheme.size.xs,
        paddingLeft: 0,
        lineHeight: euiTheme.font.lineHeightMultiplier,
        '.euiDataGridRowCell__popover &': {
          fontSize
        }
      },
      '.kbnDocViewer__fieldName_icon': {
        paddingTop: `calc(${euiTheme.size.xs} * 1.5)`,
        lineHeight: euiTheme.font.lineHeightMultiplier
      },
      '.kbnDocViewer__fieldName_multiFieldBadge': {
        margin: `${euiTheme.size.xs} 0`,
        fontWeight: euiTheme.font.weight.regular,
        fontFamily: euiTheme.font.family
      },
      '.kbnDocViewer__fieldsGrid__pinAction': {
        opacity: 0
      },
      '& [data-gridcell-column-id="pin_field"]:focus-within': {
        '.kbnDocViewer__fieldsGrid__pinAction': {
          opacity: 1
        }
      },
      '.euiDataGridRow:hover .kbnDocViewer__fieldsGrid__pinAction': {
        opacity: 1
      }
    });
  }
};