"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JsonCodeEditorCommon = exports.JSONCodeEditorCommonMemoized = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _monaco = require("@kbn/monaco");
var _eui = require("@elastic/eui");
var _codeEditor = require("@kbn/code-editor");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_doc_viewer/public/components/json_code_editor/json_code_editor_common.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const codeEditorAriaLabel = _i18n.i18n.translate('unifiedDocViewer.json.codeEditorAriaLabel', {
  defaultMessage: 'Read only JSON view of an elasticsearch document'
});
const copyToClipboardLabel = _i18n.i18n.translate('unifiedDocViewer.json.copyToClipboardLabel', {
  defaultMessage: 'Copy to clipboard'
});
const JsonCodeEditorCommon = ({
  jsonValue,
  width,
  height,
  hasLineNumbers,
  onEditorDidMount,
  hideCopyButton,
  enableFindAction
}) => {
  if (jsonValue === '') {
    return null;
  }
  const codeEditor = /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    languageId: _monaco.XJsonLang.ID,
    width: width,
    height: height,
    value: jsonValue || '',
    editorDidMount: onEditorDidMount,
    "aria-label": codeEditorAriaLabel,
    options: {
      automaticLayout: true,
      fontSize: 12,
      lineNumbers: hasLineNumbers ? 'on' : 'off',
      minimap: {
        enabled: false
      },
      overviewRulerBorder: false,
      readOnly: true,
      scrollbar: {
        alwaysConsumeMouseWheel: false
      },
      scrollBeyondLastLine: false,
      wordWrap: 'on',
      wrappingIndent: 'indent'
    },
    enableFindAction: enableFindAction,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  });
  if (hideCopyButton) {
    return codeEditor;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: styles.codeEditor,
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-textRight",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: jsonValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 11
    }
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    flush: "right",
    iconType: "copyClipboard",
    onClick: copy,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 15
    }
  }, copyToClipboardLabel)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 7
    }
  }, codeEditor));
};
exports.JsonCodeEditorCommon = JsonCodeEditorCommon;
const JSONCodeEditorCommonMemoized = exports.JSONCodeEditorCommonMemoized = /*#__PURE__*/_react.default.memo(props => {
  return /*#__PURE__*/_react.default.createElement(JsonCodeEditorCommon, (0, _extends2.default)({}, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 10
    }
  }));
});
const styles = {
  codeEditor: (0, _react2.css)`
    height: 100%;
  `
};