"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createTraceContextWhereClauseForErrors = exports.createTraceContextWhereClause = void 0;
var _discoverUtils = require("@kbn/discover-utils");
var _esqlComposer = require("@kbn/esql-composer");
var _apmTypes = require("@kbn/apm-types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createBaseTraceContextFilters = ({
  traceId,
  spanId,
  transactionId
}) => {
  let queryString = `${_discoverUtils.TRACE_ID_FIELD} == ?traceId`;
  if (transactionId && spanId) {
    queryString += ` AND (${_discoverUtils.TRANSACTION_ID_FIELD} == ?transactionId OR ${_discoverUtils.SPAN_ID_FIELD} == ?spanId)`;
  } else if (transactionId) {
    queryString += ` AND ${_discoverUtils.TRANSACTION_ID_FIELD} == ?transactionId`;
  } else if (spanId) {
    queryString += ` AND ${_discoverUtils.SPAN_ID_FIELD} == ?spanId`;
  }
  return queryString;
};
const createTraceContextWhereClause = ({
  traceId,
  spanId,
  transactionId
}) => {
  const queryString = createBaseTraceContextFilters({
    traceId,
    spanId,
    transactionId
  });
  const params = [{
    traceId
  }, {
    transactionId
  }, {
    spanId
  }];
  return (0, _esqlComposer.where)(queryString, params);
};
exports.createTraceContextWhereClause = createTraceContextWhereClause;
const createTraceContextWhereClauseForErrors = ({
  traceId,
  spanId,
  transactionId
}) => {
  let queryString = createBaseTraceContextFilters({
    traceId,
    spanId,
    transactionId
  });
  const conditions = [`${_apmTypes.PROCESSOR_EVENT}: "error"`, `${_apmTypes.ERROR_LOG_LEVEL}: "error"`, `${_apmTypes.OTEL_EVENT_NAME}: "exception"`, `${_apmTypes.OTEL_EVENT_NAME}: "error" `];
  queryString += ` AND  KQL("""${conditions.join(' OR ')}""")`;
  const params = [{
    traceId
  }, {
    transactionId
  }, {
    spanId
  }];
  return (0, _esqlComposer.where)(queryString, params);
};
exports.createTraceContextWhereClauseForErrors = createTraceContextWhereClauseForErrors;