"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DependencyNameLink = DependencyNameLink;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _routerUtils = require("@kbn/router-utils");
var _react = _interopRequireDefault(require("react"));
var _apmUiShared = require("@kbn/apm-ui-shared");
var _plugin = require("../../../../plugin");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_doc_viewer/public/components/observability/traces/components/dependency_name_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function DependencyNameLink({
  dependencyName,
  spanType,
  spanSubtype,
  environment,
  formattedDependencyName
}) {
  var _core$application$cap;
  const {
    share: {
      url: urlService
    },
    core,
    data: dataService
  } = (0, _plugin.getUnifiedDocViewerServices)();
  const canViewApm = ((_core$application$cap = core.application.capabilities.apm) === null || _core$application$cap === void 0 ? void 0 : _core$application$cap.show) || false;
  const {
    from: timeRangeFrom,
    to: timeRangeTo
  } = dataService.query.timefilter.timefilter.getTime();
  const apmLinkToDependencyOverviewLocator = urlService.locators.get(_deeplinksObservability.DEPENDENCY_OVERVIEW_LOCATOR_ID);
  const href = apmLinkToDependencyOverviewLocator === null || apmLinkToDependencyOverviewLocator === void 0 ? void 0 : apmLinkToDependencyOverviewLocator.getRedirectUrl({
    dependencyName,
    environment,
    rangeFrom: timeRangeFrom,
    rangeTo: timeRangeTo
  });
  const routeLinkProps = href ? (0, _routerUtils.getRouterLinkProps)({
    href,
    onClick: () => {
      apmLinkToDependencyOverviewLocator === null || apmLinkToDependencyOverviewLocator === void 0 ? void 0 : apmLinkToDependencyOverviewLocator.navigate({
        dependencyName,
        environment,
        rangeFrom: timeRangeFrom,
        rangeTo: timeRangeTo
      });
    }
  }) : undefined;
  const content = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_apmUiShared.SpanIcon, {
    type: spanType,
    subtype: spanSubtype,
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }, formattedDependencyName));
  return canViewApm && routeLinkProps ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({}, routeLinkProps, {
    "data-test-subj": "unifiedDocViewSpanOverviewDependencyNameLink",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 5
    }
  }), content) : content;
}