"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getColumns = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireDefault(require("react"));
var _apmTypes = require("@kbn/apm-types");
var _constants = require("../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_doc_viewer/public/components/observability/traces/components/errors/get_columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const getErrorMessage = error => {
  var _error$exception, _error$log;
  if (error !== null && error !== void 0 && (_error$exception = error.exception) !== null && _error$exception !== void 0 && _error$exception.message) {
    return error.exception.message;
  }
  if (error !== null && error !== void 0 && (_error$log = error.log) !== null && _error$log !== void 0 && _error$log.message) {
    return error.log.message;
  }
  return _constants.NOT_AVAILABLE_LABEL;
};
const getColumns = ({
  generateDiscoverLink,
  traceId,
  docId,
  source
}) => [{
  field: 'name',
  name: _i18n.i18n.translate('unifiedDocViewer.observability.traces.docViewerSpanOverview.errors.table.error', {
    defaultMessage: 'Error message and culprit'
  }),
  sortable: item => {
    var _item$error, _item$error$exception;
    return ((_item$error = item.error) === null || _item$error === void 0 ? void 0 : (_item$error$exception = _item$error.exception) === null || _item$error$exception === void 0 ? void 0 : _item$error$exception.message) || '';
  },
  render: (_, item) => {
    var _item$error2, _item$error2$exceptio;
    const href = generateDiscoverLink({
      [_apmTypes.TRACE_ID]: traceId,
      ...(docId && {
        [_apmTypes.SPAN_ID]: docId
      }),
      ...(source === 'apm' ? {
        [_apmTypes.PROCESSOR_EVENT]: 'error',
        [_apmTypes.ERROR_ID]: item.error.id
      } : null),
      ...(source === 'unprocessedOtel' ? {
        [_apmTypes.EVENT_NAME]: item === null || item === void 0 ? void 0 : item.eventName,
        [_apmTypes.EXCEPTION_MESSAGE]: item === null || item === void 0 ? void 0 : (_item$error2 = item.error) === null || _item$error2 === void 0 ? void 0 : (_item$error2$exceptio = _item$error2.exception) === null || _item$error2$exceptio === void 0 ? void 0 : _item$error2$exceptio.message
      } : null)
    });
    const content = /*#__PURE__*/_react2.default.createElement(_eui.EuiTextTruncate, {
      "data-test-subj": "error-exception-message",
      text: getErrorMessage(item.error),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 9
      }
    });
    return /*#__PURE__*/_react2.default.createElement("span", {
      css: (0, _react.css)`
            width: 100%;
          `,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 9
      }
    }, href ? /*#__PURE__*/_react2.default.createElement(_eui.EuiLink, {
      "data-test-subj": "error-group-link",
      href: href,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 13
      }
    }, content) : content, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTextTruncate, {
      "data-test-subj": "error-culprit",
      text: item.error.culprit || _constants.NOT_AVAILABLE_LABEL,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 13
      }
    })));
  }
}];
exports.getColumns = getColumns;