"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FullScreenWaterfall = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _public = require("@kbn/embeddable-plugin/public");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireWildcard(require("react"));
var _exit_full_screen_button = require("./exit_full_screen_button");
var _span_flyout = require("./waterfall_flyout/span_flyout");
var _logs_flyout = require("./waterfall_flyout/logs_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_doc_viewer/public/components/observability/traces/components/full_screen_waterfall/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FullScreenWaterfall = ({
  traceId,
  rangeFrom,
  rangeTo,
  dataView,
  serviceName,
  onExitFullScreen
}) => {
  const [docId, setDocId] = (0, _react2.useState)(null);
  const [activeFlyoutId, setActiveFlyoutId] = (0, _react2.useState)(null);
  const [activeSection, setActiveSection] = (0, _react2.useState)();
  const overlayMaskRef = (0, _react2.useRef)(null);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const getParentApi = (0, _react2.useCallback)(() => ({
    getSerializedStateForChild: () => ({
      rawState: {
        traceId,
        rangeFrom,
        rangeTo,
        serviceName,
        scrollElement: overlayMaskRef.current,
        onErrorClick: params => {
          if (params.errorCount > 1) {
            setActiveFlyoutId(_span_flyout.spanFlyoutId);
            setActiveSection('errors-table');
            setDocId(params.docId);
          } else if (params.errorDocId) {
            setActiveFlyoutId(_logs_flyout.logsFlyoutId);
            setDocId(params.errorDocId);
          }
        },
        onNodeClick: nodeSpanId => {
          setActiveSection(undefined);
          setDocId(nodeSpanId);
          setActiveFlyoutId(_span_flyout.spanFlyoutId);
        },
        mode: 'full'
      }
    })
  }), [traceId, rangeFrom, rangeTo, serviceName]);
  function handleCloseFlyout() {
    setActiveFlyoutId(null);
    setActiveSection(undefined);
    setDocId(null);
  }
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_react.Global, {
    styles: (0, _react.css)`
          .euiDataGridRowCell__popover {
            z-index: ${euiTheme.levels.modal} !important;
          }
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiOverlayMask, {
    maskRef: overlayMaskRef,
    css: {
      paddingBlockEnd: '0 !important',
      overflowY: 'scroll',
      backgroundColor: `${euiTheme.colors.backgroundBasePlain} !important`
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFocusTrap, {
    css: {
      height: '100%',
      width: '100%'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    css: {
      minHeight: '100%',
      width: '100%'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react2.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('unifiedDocViewer.observability.traces.fullScreenWaterfall.title', {
    defaultMessage: 'Trace timeline'
  })))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    css: {
      alignItems: 'end'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_exit_full_screen_button.ExitFullScreenButton, {
    onExitFullScreen: onExitFullScreen,
    dataTestSubj: "unifiedDocViewerObservabilityTracesFullScreenWaterfallExitFullScreenButton",
    ariaLabel: _i18n.i18n.translate('unifiedDocViewer.observability.traces.fullScreenWaterfall.exitFullScreen.button', {
      defaultMessage: 'Exit expanded trace timeline'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_public.EmbeddableRenderer, {
    type: "APM_TRACE_WATERFALL_EMBEDDABLE",
    getParentApi: getParentApi,
    hidePanelChrome: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 17
    }
  })))))), docId && activeFlyoutId ? activeFlyoutId === _span_flyout.spanFlyoutId ? /*#__PURE__*/_react2.default.createElement(_span_flyout.SpanFlyout, {
    traceId: traceId,
    spanId: docId,
    dataView: dataView,
    onCloseFlyout: handleCloseFlyout,
    activeSection: activeSection,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react2.default.createElement(_logs_flyout.LogsFlyout, {
    onCloseFlyout: handleCloseFlyout,
    id: docId,
    dataView: dataView,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 11
    }
  }) : null);
};
exports.FullScreenWaterfall = FullScreenWaterfall;