"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HighlightField = HighlightField;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_doc_viewer/public/components/observability/traces/components/highlight_field/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function HighlightField({
  value,
  formattedValue,
  children,
  textSize = 'xs',
  as
}) {
  const formattedContent = formattedValue ? /*#__PURE__*/_react.default.createElement(FormattedValue, {
    value: formattedValue,
    textSize: textSize,
    as: as,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 5
    }
  }) : null;
  const valueContent = value ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: textSize,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 32
    }
  }, value) : null;
  const content = formattedContent !== null && formattedContent !== void 0 ? formattedContent : valueContent;
  if (typeof children === 'function') {
    return children({
      content
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, content);
}
const FormattedValue = ({
  value,
  textSize,
  as
}) => {
  if (as) {
    const As = as;
    return /*#__PURE__*/_react.default.createElement(As
    // Value returned from formatFieldValue is always sanitized
    , {
      dangerouslySetInnerHTML: {
        __html: value
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    className: "eui-textTruncate",
    size: textSize
    // Value returned from formatFieldValue is always sanitized
    ,
    dangerouslySetInnerHTML: {
      __html: value
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  });
};