"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TraceContextLogEvents = TraceContextLogEvents;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _lazy_content_framework_section = require("../../../../content_framework/lazy_content_framework_section");
var _plugin = require("../../../../../plugin");
var _use_data_sources = require("../../hooks/use_data_sources");
var _use_logs_query = require("../../hooks/use_logs_query");
var _use_get_generate_discover_link = require("../../hooks/use_get_generate_discover_link");
var _create_trace_context_where_clause = require("../../common/create_trace_context_where_clause");
var _constants = require("../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_doc_viewer/public/components/observability/traces/components/trace_context_log_events/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const logsTitle = _i18n.i18n.translate('unifiedDocViewer.observability.traces.section.logs.title', {
  defaultMessage: 'Logs'
});
const logsDescription = _i18n.i18n.translate('unifiedDocViewer.observability.traces.section.logs.description', {
  defaultMessage: 'Correlated logs that occurred during the span.'
});
function TraceContextLogEvents({
  traceId,
  transactionId,
  spanId
}) {
  const {
    data: dataService,
    discoverShared
  } = (0, _plugin.getUnifiedDocViewerServices)();
  const {
    indexes
  } = (0, _use_data_sources.useDataSourcesContext)();
  const {
    from,
    to
  } = dataService.query.timefilter.timefilter.getTime();
  const {
    generateDiscoverLink
  } = (0, _use_get_generate_discover_link.useGetGenerateDiscoverLink)({
    indexPattern: indexes.logs
  });
  const timeRange = (0, _react.useMemo)(() => ({
    from,
    to
  }), [from, to]);
  const query = (0, _use_logs_query.useLogsQuery)({
    traceId,
    spanId,
    transactionId
  });
  const savedSearchTimeRange = (0, _react.useMemo)(() => ({
    from: timeRange.from,
    to: timeRange.to
  }), [timeRange.from, timeRange.to]);
  const openInDiscoverLink = (0, _react.useMemo)(() => {
    return generateDiscoverLink((0, _create_trace_context_where_clause.createTraceContextWhereClause)({
      traceId,
      spanId,
      transactionId
    }));
  }, [generateDiscoverLink, traceId, spanId, transactionId]);
  const LogEvents = discoverShared.features.registry.getById('observability-log-events');
  if (!LogEvents || !indexes.logs) {
    return null;
  }
  const LogEventsComponent = LogEvents.render;
  return /*#__PURE__*/_react.default.createElement(_lazy_content_framework_section.ContentFrameworkSection, {
    title: logsTitle,
    description: logsDescription,
    id: "traceContextLogEvents",
    forceState: "closed",
    actions: openInDiscoverLink ? [{
      icon: 'discoverApp',
      label: _constants.OPEN_IN_DISCOVER_LABEL,
      ariaLabel: _constants.OPEN_IN_DISCOVER_LABEL_ARIAL_LABEL,
      href: openInDiscoverLink,
      dataTestSubj: 'unifiedDocViewerLogsOpenInDiscoverButton'
    }] : undefined,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    tabIndex: 0,
    className: "eui-yScrollWithShadows",
    style: {
      maxHeight: '400px'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(LogEventsComponent, {
    query: query,
    timeRange: savedSearchTimeRange,
    index: indexes.logs,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 9
    }
  })));
}