"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toESQLParamName = void 0;
exports.useGetGenerateDiscoverLink = useGetGenerateDiscoverLink;
var _esqlComposer = require("@kbn/esql-composer");
var _lodash = require("lodash");
var _plugin = require("../../../../plugin");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function useGetGenerateDiscoverLink({
  indexPattern
}) {
  const {
    data,
    share: {
      url: {
        locators
      }
    }
  } = (0, _plugin.getUnifiedDocViewerServices)();
  const timeRange = data.query.timefilter.timefilter.getAbsoluteTime();
  const discoverLocator = locators.get('DISCOVER_APP_LOCATOR');
  const indices = (0, _lodash.castArray)(indexPattern).filter(Boolean);
  const generateDiscoverLink = (first, ...rest) => {
    if (!discoverLocator || !indices.length) {
      return undefined;
    }
    let esql;
    const _from = (0, _esqlComposer.from)(indices.join());
    if (typeof first === 'function') {
      esql = _from.pipe(first, ...rest).toString();
    } else if (first && typeof first === 'object') {
      const whereClause = first;
      const paramKeysMap = new Map();
      const params = [];
      Object.keys(whereClause).forEach(key => {
        const paramKey = toESQLParamName(key);
        paramKeysMap.set(key, paramKey);
        params.push({
          [paramKey]: whereClause[key]
        });
      });
      esql = _from.pipe((0, _esqlComposer.where)(Object.keys(whereClause).map(key => `${key} == ?${paramKeysMap.get(key)}`).join(' AND '), params)).toString();
    } else {
      esql = _from.toString();
    }
    const url = discoverLocator.getRedirectUrl({
      timeRange,
      filters: [],
      query: {
        language: 'kuery',
        esql
      }
    });
    return url;
  };
  return {
    generateDiscoverLink
  };
}
const toESQLParamName = str => str.replaceAll('.', '_');
exports.toESQLParamName = toESQLParamName;