"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createFilterAction = createFilterAction;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _public = require("@kbn/ui-actions-plugin/public");
var _esQuery = require("@kbn/es-query");
var _services = require("../../services");
var _apply_filter_popover_content = require("./apply_filter_popover_content");
var _constants = require("../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_search/public/actions/apply_filter_action/apply_filter_action.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
async function isCompatible(context) {
  return context.filters !== undefined;
}
function createFilterAction(filterManager, timeFilter, coreStart, id = _constants.ACTION_GLOBAL_APPLY_FILTER, type = _constants.ACTION_GLOBAL_APPLY_FILTER) {
  return {
    type,
    id,
    order: 100,
    getIconType: () => 'filter',
    getDisplayName: () => {
      return _i18n.i18n.translate('unifiedSearch.filter.applyFilterActionTitle', {
        defaultMessage: 'Apply filter to current view'
      });
    },
    isCompatible,
    execute: async ({
      filters,
      timeFieldName,
      controlledBy
    }) => {
      if (!filters) {
        throw new Error('Applying a filter requires a filter');
      }
      if (!(await isCompatible({
        filters
      }))) {
        throw new _public.IncompatibleActionError();
      }
      let selectedFilters = filters;
      if (selectedFilters.length > 1) {
        const indexPatterns = await Promise.all(filters.map(filter => {
          return (0, _services.getIndexPatterns)().get(filter.meta.index);
        }));
        const filterSelectionPromise = new Promise(resolve => {
          const overlay = coreStart.overlays.openModal((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_apply_filter_popover_content.ApplyFiltersPopoverContent, {
            indexPatterns: indexPatterns,
            filters: filters,
            onCancel: () => {
              overlay.close();
              resolve([]);
            },
            onSubmit: filterSelection => {
              overlay.close();
              resolve(filterSelection);
            },
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 75,
              columnNumber: 15
            }
          }), coreStart), {
            'data-test-subj': 'test'
          });
        });
        selectedFilters = await filterSelectionPromise;
      }

      // remove existing filters for control prior to adding new filtes for control
      if (controlledBy) {
        filterManager.getFilters().forEach(filter => {
          if (filter.meta.controlledBy === controlledBy) {
            filterManager.removeFilter(filter);
          }
        });
      }
      if (timeFieldName) {
        const {
          timeRangeFilter,
          restOfFilters
        } = (0, _esQuery.extractTimeFilter)(timeFieldName, selectedFilters);
        filterManager.addFilters(restOfFilters);
        if (timeRangeFilter) {
          timeFilter.setTime((0, _esQuery.convertRangeFilterToTimeRange)(timeRangeFilter));
        }
      } else {
        filterManager.addFilters(selectedFilters);
      }
    }
  };
}