"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterExpressionBadge = FilterExpressionBadge;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/data-plugin/public");
var _esQuery = require("@kbn/es-query");
var _eui = require("@elastic/eui");
var _filter_badge_group = require("./filter_badge_group");
var _filter_content = require("./filter_content");
var _utils = require("../utils");
var _filter_badge_invalid = require("./filter_badge_invalid");
var _filter_badge = require("./filter_badge.styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_search/public/filter_badge/filter_badge_expression.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const FilterBadgeContent = ({
  filter,
  dataViews,
  filterLabelStatus
}) => {
  const valueLabel = filterLabelStatus || (0, _public.getDisplayValueFromFilter)(filter, dataViews);
  const fieldLabel = (0, _public.getFieldDisplayValueFromFilter)(filter, dataViews);
  if (!valueLabel || !filter) {
    return /*#__PURE__*/_react.default.createElement(_filter_badge_invalid.FilterBadgeInvalidPlaceholder, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_filter_content.FilterContent, {
    filter: filter,
    valueLabel: valueLabel,
    fieldLabel: fieldLabel,
    hideAlias: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  });
};
function FilterExpressionBadge({
  filter,
  shouldShowBrackets,
  dataViews,
  filterLabelStatus
}) {
  var _filter$meta;
  const isCombined = (0, _esQuery.isCombinedFilter)(filter);
  const conditionalOperationType = (0, _utils.getBooleanRelationType)(filter);
  return conditionalOperationType && isCombined ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, shouldShowBrackets && /*#__PURE__*/_react.default.createElement("span", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    className: _filter_badge.bracketColorCss,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 11
    }
  }, "(")), /*#__PURE__*/_react.default.createElement(_filter_badge_group.FilterBadgeGroup, {
    filters: (_filter$meta = filter.meta) === null || _filter$meta === void 0 ? void 0 : _filter$meta.params,
    dataViews: dataViews,
    filterLabelStatus: filterLabelStatus,
    booleanRelation: (0, _utils.getBooleanRelationType)(filter),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }), shouldShowBrackets && /*#__PURE__*/_react.default.createElement("span", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    className: _filter_badge.bracketColorCss,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 11
    }
  }, ")"))) : /*#__PURE__*/_react.default.createElement("span", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(FilterBadgeContent, {
    filter: filter,
    dataViews: dataViews,
    filterLabelStatus: filterLabelStatus,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }));
}