"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatDateChange = exports.RangeValueInput = void 0;
exports.isRangeParams = isRangeParams;
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _value_input_type = require("./value_input_type");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_search/public/filter_bar/filter_editor/range_value_input.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function isRangeParams(params) {
  return Boolean(params && 'from' in params && 'to' in params);
}
const formatDateChange = (value, kibana) => {
  if (typeof value !== 'string' && typeof value !== 'number') return value;
  const tzConfig = kibana.services.uiSettings.get('dateFormat:tz');
  const tz = !tzConfig || tzConfig === 'Browser' ? _moment.default.tz.guess() : tzConfig;
  const momentParsedValue = (0, _moment.default)(value).tz(tz);
  if (momentParsedValue.isValid()) return momentParsedValue === null || momentParsedValue === void 0 ? void 0 : momentParsedValue.format('YYYY-MM-DDTHH:mm:ss.SSSZ');
  return value;
};
exports.formatDateChange = formatDateChange;
function RangeValueInputUI(props) {
  const kibana = (0, _public.useKibana)();
  const onFromChange = value => {
    if (typeof value !== 'string' && typeof value !== 'number') {
      throw new Error('Range params must be a string or number');
    }
    props.onChange({
      from: value === '' ? undefined : value,
      to: (0, _lodash.get)(props, 'value.to')
    });
  };
  const onToChange = value => {
    if (typeof value !== 'string' && typeof value !== 'number') {
      throw new Error('Range params must be a string or number');
    }
    props.onChange({
      from: (0, _lodash.get)(props, 'value.from'),
      to: value === '' ? undefined : value
    });
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormControlLayoutDelimited, {
    compressed: props.compressed,
    fullWidth: props.fullWidth,
    "aria-label": props.intl.formatMessage({
      id: 'unifiedSearch.filter.filterEditor.rangeInputLabel',
      defaultMessage: 'Range'
    }),
    startControl: /*#__PURE__*/_react.default.createElement(_value_input_type.ValueInputType, {
      controlOnly: true,
      compressed: props.compressed,
      field: props.field,
      value: props.value ? props.value.from : undefined,
      onChange: onFromChange,
      onBlur: value => {
        onFromChange(formatDateChange(value, kibana));
      },
      placeholder: props.intl.formatMessage({
        id: 'unifiedSearch.filter.filterEditor.rangeStartInputPlaceholder',
        defaultMessage: 'Start'
      }),
      disabled: props.disabled,
      dataTestSubj: "range-start",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 11
      }
    }),
    endControl: /*#__PURE__*/_react.default.createElement(_value_input_type.ValueInputType, {
      controlOnly: true,
      compressed: props.compressed,
      field: props.field,
      value: props.value ? props.value.to : undefined,
      onChange: onToChange,
      onBlur: value => {
        onToChange(formatDateChange(value, kibana));
      },
      placeholder: props.intl.formatMessage({
        id: 'unifiedSearch.filter.filterEditor.rangeEndInputPlaceholder',
        defaultMessage: 'End'
      }),
      disabled: props.disabled,
      dataTestSubj: "range-end",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 11
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }));
}
const RangeValueInput = exports.RangeValueInput = (0, _i18nReact.injectI18n)(RangeValueInputUI);