"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.strings = exports.FilterGroup = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _esQuery = require("@kbn/es-query");
var _css = require("@emotion/css");
var _utils = require("../utils");
var _filter_item = require("./filter_item");
var _context = require("./context");
var _utils2 = require("./utils");
var _filter_group = require("./filter_group.styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_search/public/filters_builder/filter_group.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const strings = exports.strings = {
  getDelimiterLabel: booleanRelation => _i18n.i18n.translate('unifiedSearch.filter.filtersBuilder.delimiterLabel', {
    defaultMessage: '{booleanRelation}',
    values: {
      booleanRelation
    }
  })
};
/** @internal **/
const Delimiter = ({
  color,
  booleanRelation
}) => {
  const xsPadding = (0, _eui.useEuiPaddingSize)('xs');
  const mPadding = (0, _eui.useEuiPaddingSize)('m');
  const backgroundColor = (0, _eui.useEuiBackgroundColor)(color);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _filter_group.delimiterCss)({
      padding: xsPadding,
      left: mPadding,
      background: backgroundColor
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    className: "filter-builder__delimiter_text",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }, strings.getDelimiterLabel(booleanRelation)));
};
const FilterGroup = ({
  filters,
  booleanRelation,
  path,
  reverseBackground = false,
  renderedLevel = 0,
  filtersCount
}) => {
  const {
    globalParams: {
      maxDepth,
      hideOr
    }
  } = (0, _react.useContext)(_context.FiltersBuilderContextType);
  const pathInArray = (0, _utils2.getPathInArray)(path);
  const isDepthReached = maxDepth <= pathInArray.length && renderedLevel > 0;
  const orDisabled = hideOr || isDepthReached && booleanRelation === _esQuery.BooleanRelation.AND;
  const andDisabled = isDepthReached && booleanRelation === _esQuery.BooleanRelation.OR;
  const removeDisabled = pathInArray.length <= 1 && filters !== undefined && Array.isArray(filters) && filters.length === 1;
  const shouldNormalizeFirstLevel = !path && filters && Array.isArray(filters) && filters.length === 1 && (0, _utils.getBooleanRelationType)(filters[0]);
  if (shouldNormalizeFirstLevel) {
    reverseBackground = true;
    renderedLevel -= 1;
  }
  const color = reverseBackground ? 'plain' : 'subdued';
  const renderedFilters = filters && Array.isArray(filters) && filters.map((filter, index, arrayRef) => {
    const showDelimiter = booleanRelation && index + 1 < arrayRef.length;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      key: index,
      direction: "column",
      gutterSize: shouldNormalizeFirstLevel ? 'none' : 'xs',
      responsive: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_filter_item.FilterItem, {
      filter: filter,
      draggable: arrayRef.length !== 1,
      path: `${path}${path ? '.' : ''}${index}`,
      reverseBackground: reverseBackground,
      disableOr: orDisabled,
      disableAnd: andDisabled,
      disableRemove: removeDisabled,
      color: color,
      index: index,
      renderedLevel: renderedLevel,
      filtersCount: filtersCount,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 13
      }
    })), showDelimiter && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(Delimiter, {
      color: color,
      booleanRelation: booleanRelation,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 15
      }
    })));
  });
  return shouldNormalizeFirstLevel ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, renderedFilters) : /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: color,
    hasShadow: false,
    paddingSize: renderedLevel > 0 ? 'none' : 'xs',
    hasBorder: true,
    className: (0, _css.cx)({
      'filter-builder__panel': true,
      'filter-builder__panel-nested': renderedLevel > 0
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 5
    }
  }, renderedFilters);
};
exports.FilterGroup = FilterGroup;