"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OperatorInput = OperatorInput;
exports.strings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _filter_editor = require("../../filter_bar/filter_editor");
var _context = require("../context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_search/public/filters_builder/filter_item/operator_input.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const strings = exports.strings = {
  getOperatorSelectPlaceholderSelectLabel: () => _i18n.i18n.translate('unifiedSearch.filter.filtersBuilder.operatorSelectPlaceholderSelect', {
    defaultMessage: 'Select operator'
  })
};
function OperatorInput({
  field,
  operator,
  params,
  onHandleOperator
}) {
  const {
    disabled
  } = (0, _react.useContext)(_context.FiltersBuilderContextType);
  const operators = field ? (0, _filter_editor.getOperatorOptions)(field) : [];
  const onOperatorChange = (0, _react.useCallback)(([selectedOperator]) => {
    const selectedParams = selectedOperator === operator ? params : undefined;
    onHandleOperator(selectedOperator, selectedParams);
  }, [onHandleOperator, operator, params]);
  return /*#__PURE__*/_react.default.createElement(_filter_editor.GenericComboBox, {
    fullWidth: true,
    compressed: true,
    isDisabled: !field || disabled,
    placeholder: strings.getOperatorSelectPlaceholderSelectLabel(),
    "aria-label": strings.getOperatorSelectPlaceholderSelectLabel(),
    options: operators,
    selectedOptions: operator ? [operator] : [],
    getLabel: ({
      message
    }) => message,
    onChange: onOperatorChange,
    singleSelection: {
      asPlainText: true
    },
    isClearable: false,
    "data-test-subj": "filterOperatorList",
    inputPopoverProps: {
      panelMinWidth: 180
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  });
}