"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.strings = exports.QueryLanguageSwitcher = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_search/public/query_string_input/language_switcher.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const strings = exports.strings = {
  getSwitchLanguageButtonText: () => _i18n.i18n.translate('unifiedSearch.switchLanguage.buttonText', {
    defaultMessage: 'Switch language button.'
  }),
  getFilterLanguageLabel: () => _i18n.i18n.translate('unifiedSearch.switchLanguage.filterLanguageLabel', {
    defaultMessage: 'Filter language'
  }),
  documentationLabel: () => _i18n.i18n.translate('unifiedSearch.switchLanguage.documentationLabel', {
    defaultMessage: 'Documentation'
  })
};
const QueryLanguageSwitcher = exports.QueryLanguageSwitcher = /*#__PURE__*/_react.default.memo(function QueryLanguageSwitcher({
  language,
  anchorPosition,
  onSelectLanguage,
  nonKqlMode = 'lucene',
  isOnTopBarMenu,
  isDisabled,
  deps: {
    docLinks
  }
}) {
  const kueryQuerySyntaxDocs = docLinks.links.query.kueryQuerySyntax;
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    size: "s",
    iconType: "filter",
    onClick: () => setIsPopoverOpen(!isPopoverOpen),
    className: "kqlQueryBar__languageSwitcherButton",
    "data-test-subj": 'switchQueryLanguageButton',
    "aria-label": strings.getSwitchLanguageButtonText(),
    disabled: isDisabled,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 5
    }
  });
  const isKqlSelected = language === 'kuery';
  const languageMenuItem = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    "aria-label": strings.getFilterLanguageLabel(),
    options: [{
      key: 'kuery',
      label: 'KQL',
      'data-test-subj': 'kqlLanguageMenuItem',
      checked: isKqlSelected ? 'on' : undefined
    }, {
      key: nonKqlMode,
      label: (0, _eui.toSentenceCase)(nonKqlMode),
      'data-test-subj': 'luceneLanguageMenuItem',
      checked: !isKqlSelected ? 'on' : undefined
    }],
    onChange: newOptions => {
      const selectedOptions = newOptions.find(option => option.checked === 'on');
      if (selectedOptions) {
        onSelectLanguage(selectedOptions.key);
      }
    },
    singleSelection: true,
    listProps: {
      bordered: false
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }, list => list), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: 'documentation',
    icon: 'documentation',
    href: kueryQuerySyntaxDocs,
    target: "_blank",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 7
    }
  }, strings.documentationLabel()));
  const languageQueryStringComponent = /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "queryLanguageSwitcherPopover",
    anchorPosition: anchorPosition || 'downLeft',
    button: button,
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    repositionOnScroll: true,
    panelPaddingSize: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "unifiedSearch.query.queryBar.syntaxOptionsTitle",
    defaultMessage: "Syntax options",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 9
    }
  })), languageMenuItem);
  return Boolean(isOnTopBarMenu) ? languageMenuItem : languageQueryStringComponent;
});