"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSearchBar = createSearchBar;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _ = require(".");
var _use_filter_manager = require("./lib/use_filter_manager");
var _use_timefilter = require("./lib/use_timefilter");
var _use_saved_query = require("./lib/use_saved_query");
var _use_query_string_manager = require("./lib/use_query_string_manager");
var _can_show_saved_query = require("./lib/can_show_saved_query");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_search/public/search_bar/create_search_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// Respond to user changing the filters
const defaultFiltersUpdated = (queryService, onFiltersUpdated) => {
  return filters => {
    if (onFiltersUpdated) {
      onFiltersUpdated(filters);
    } else {
      queryService.filterManager.setFilters(filters);
    }
  };
};

// Respond to user changing the refresh settings
const defaultOnRefreshChange = (queryService, onRefreshChange) => {
  const {
    timefilter
  } = queryService.timefilter;
  return options => {
    timefilter.setRefreshInterval({
      value: options.refreshInterval,
      pause: options.isPaused
    });
    if (onRefreshChange) {
      onRefreshChange({
        refreshInterval: options.refreshInterval,
        isPaused: options.isPaused
      });
    }
  };
};

// Respond to user changing the query string or time settings
const defaultOnQuerySubmit = (props, queryService, currentQuery) => {
  if (!props.useDefaultBehaviors) return props.onQuerySubmit;
  const {
    timefilter
  } = queryService.timefilter;
  return payload => {
    const isUpdate = !(0, _lodash.isEqual)(timefilter.getTime(), payload.dateRange) || !(0, _lodash.isEqual)(payload.query, currentQuery);
    if (isUpdate) {
      timefilter.setTime(payload.dateRange);
      if (payload.query) {
        queryService.queryString.setQuery(payload.query);
      } else {
        queryService.queryString.clearQuery();
      }
    } else {
      // Refresh button triggered for an update
      if (props.onQuerySubmit) props.onQuerySubmit({
        dateRange: timefilter.getTime(),
        query: currentQuery
      }, false);
    }
  };
};

// Respond to user clearing a saved query
const defaultOnClearSavedQuery = (props, clearSavedQuery) => {
  if (!props.useDefaultBehaviors) return props.onClearSavedQuery;
  return () => {
    clearSavedQuery();
    if (props.onSavedQueryIdChange) props.onSavedQueryIdChange();
  };
};

// Respond to user saving or updating a saved query
const defaultOnSavedQueryUpdated = (props, setSavedQuery) => {
  if (!props.useDefaultBehaviors) return props.onSavedQueryUpdated;
  return savedQuery => {
    setSavedQuery(savedQuery);
    if (props.onSavedQueryIdChange) props.onSavedQueryIdChange(savedQuery.id);
  };
};
const overrideDefaultBehaviors = props => {
  return props.useDefaultBehaviors ? {} : props;
};
function createSearchBar({
  core,
  storage,
  data,
  usageCollection,
  isScreenshotMode = false,
  unifiedSearch
}) {
  // App name should come from the core application service.
  // Until it's available, we'll ask the user to provide it for the pre-wired component.
  return props => {
    const {
      useDefaultBehaviors,
      allowSavingQueries
    } = props;
    // Handle queries
    const onQuerySubmitRef = (0, _react.useRef)(props.onQuerySubmit);
    (0, _react.useEffect)(() => {
      onQuerySubmitRef.current = props.onQuerySubmit;
    }, [props.onQuerySubmit]);
    // handle service state updates.
    // i.e. filters being added from a visualization directly to filterManager.
    const {
      filters
    } = (0, _use_filter_manager.useFilterManager)({
      filters: props.filters,
      filterManager: data.query.filterManager
    });
    const {
      query
    } = (0, _use_query_string_manager.useQueryStringManager)({
      query: props.query,
      queryStringManager: data.query.queryString
    });
    const {
      timeRange,
      refreshInterval,
      minRefreshInterval
    } = (0, _use_timefilter.useTimefilter)({
      dateRangeFrom: props.dateRangeFrom,
      dateRangeTo: props.dateRangeTo,
      refreshInterval: props.refreshInterval,
      isRefreshPaused: props.isRefreshPaused,
      timefilter: data.query.timefilter.timefilter
    });

    // Fetch and update UI from saved query
    const {
      savedQuery,
      setSavedQuery,
      clearSavedQuery
    } = (0, _use_saved_query.useSavedQuery)({
      queryService: data.query,
      savedQueryId: props.savedQueryId,
      notifications: core.notifications
    });

    // Fire onQuerySubmit on query or timerange change
    (0, _react.useEffect)(() => {
      if (!useDefaultBehaviors || !onQuerySubmitRef.current) return;
      onQuerySubmitRef.current({
        dateRange: timeRange,
        query
      }, true);
    }, [query, timeRange, useDefaultBehaviors]);
    const showSaveQuery = (0, _can_show_saved_query.canShowSavedQuery)({
      allowSavingQueries,
      query,
      core
    });
    return /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
      services: {
        appName: props.appName,
        data,
        storage,
        usageCollection,
        unifiedSearch,
        ...core
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 214,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(core.i18n.Context, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 224,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_.SearchBar, (0, _extends2.default)({
      showAutoRefreshOnly: props.showAutoRefreshOnly,
      showDatePicker: props.showDatePicker,
      showFilterBar: props.showFilterBar,
      showQueryMenu: props.showQueryMenu,
      showQueryInput: props.showQueryInput,
      showSaveQuery: showSaveQuery,
      showSubmitButton: props.showSubmitButton,
      submitButtonStyle: props.submitButtonStyle,
      isDisabled: props.isDisabled,
      screenTitle: props.screenTitle,
      indexPatterns: props.indexPatterns,
      indicateNoData: props.indicateNoData,
      timeHistory: data.query.timefilter.history,
      dateRangeFrom: timeRange.from,
      dateRangeTo: timeRange.to,
      minRefreshInterval: minRefreshInterval,
      refreshInterval: refreshInterval.value,
      isRefreshPaused: refreshInterval.pause,
      isLoading: props.isLoading,
      onCancel: props.onCancel,
      filters: filters,
      query: query,
      draft: props.draft,
      onDraftChange: props.onDraftChange,
      onFiltersUpdated: defaultFiltersUpdated(data.query, props.onFiltersUpdated),
      onRefreshChange: !props.isAutoRefreshDisabled ? defaultOnRefreshChange(data.query, props.onRefreshChange) : undefined,
      savedQuery: savedQuery,
      onQuerySubmit: defaultOnQuerySubmit(props, data.query, query),
      onRefresh: props.onRefresh,
      onClearSavedQuery: defaultOnClearSavedQuery(props, clearSavedQuery),
      onSavedQueryUpdated: defaultOnSavedQueryUpdated(props, setSavedQuery),
      onSaved: defaultOnSavedQueryUpdated(props, setSavedQuery),
      iconType: props.iconType,
      nonKqlMode: props.nonKqlMode,
      customSubmitButton: props.customSubmitButton,
      dataViewPickerOverride: props.dataViewPickerOverride,
      isClearable: props.isClearable,
      placeholder: props.placeholder,
      additionalQueryBarMenuItems: props.additionalQueryBarMenuItems
    }, overrideDefaultBehaviors(props), {
      dataViewPickerComponentProps: props.dataViewPickerComponentProps,
      textBasedLanguageModeErrors: props.textBasedLanguageModeErrors,
      textBasedLanguageModeWarning: props.textBasedLanguageModeWarning,
      displayStyle: props.displayStyle,
      isScreenshotMode: isScreenshotMode,
      dataTestSubj: props.dataTestSubj,
      filtersForSuggestions: props.filtersForSuggestions,
      prependFilterBar: props.prependFilterBar,
      onESQLDocsFlyoutVisibilityChanged: props.onESQLDocsFlyoutVisibilityChanged,
      esqlEditorInitialState: props.esqlEditorInitialState,
      onEsqlEditorInitialStateChange: props.onEsqlEditorInitialStateChange,
      esqlVariablesConfig: props.esqlVariablesConfig,
      useBackgroundSearchButton: props.useBackgroundSearchButton,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 225,
        columnNumber: 11
      }
    }))));
  };
}