"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SuggestionComponent = void 0;
var _eui = require("@elastic/eui");
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _use_memo_css = require("../use_memo_css");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_search/public/typeahead/suggestion_component.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getEuiIconType(type) {
  switch (type) {
    case 'field':
      return 'kqlField';
    case 'value':
      return 'kqlValue';
    case 'recentSearch':
      return 'search';
    case 'conjunction':
      return 'kqlSelector';
    case 'operator':
      return 'kqlOperand';
    default:
      throw new Error(`Unknown type: ${type}`);
  }
}
const SuggestionComponent = exports.SuggestionComponent = /*#__PURE__*/_react.default.memo(function SuggestionComponent(props) {
  const {
    index,
    innerRef,
    onClick,
    onMouseEnter,
    suggestion
  } = props;
  const setRef = (0, _react.useCallback)(node => {
    innerRef(index, node);
  }, [index, innerRef]);
  const handleClick = (0, _react.useCallback)(() => {
    onClick(suggestion, index);
  }, [index, onClick, suggestion]);
  const handleMouseEnter = (0, _react.useCallback)(() => {
    onMouseEnter(suggestion, index);
  }, [index, onMouseEnter, suggestion]);
  const styles = (0, _use_memo_css.useMemoCss)(suggestionStyles);
  return (
    /*#__PURE__*/
    // eslint-disable-next-line jsx-a11y/click-events-have-key-events, jsx-a11y/interactive-supports-focus
    _react.default.createElement("div", {
      className: (0, _classnames.default)('kbnTypeahead__item', {
        active: props.selected
      }),
      css: styles.suggestionItem,
      role: "option",
      onMouseEnter: handleMouseEnter,
      onClick: handleClick,
      ref: setRef,
      id: props.ariaId,
      "aria-selected": props.selected,
      "data-test-subj": `autocompleteSuggestion-${props.suggestion.type}-${props.suggestion.text.replace(/\s/g, '-')}`,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 5
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: (0, _classnames.default)({
        kbnSuggestionItem: true,
        ['kbnSuggestionItem--' + props.suggestion.type]: true
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "kbnSuggestionItem__type",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: getEuiIconType(props.suggestion.type),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement("div", {
      className: "kbnSuggestionItem__text",
      "data-test-subj": "autoCompleteSuggestionText",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 9
      }
    }, props.suggestion.text), props.shouldDisplayDescription && /*#__PURE__*/_react.default.createElement("div", {
      className: "kbnSuggestionItem__description",
      "data-test-subj": "autoCompleteSuggestionDescription",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 11
      }
    }, props.suggestion.description)))
  );
});

// These are the various types in the dropdown, they each get a color
const kbnTypeaheadTypes = {
  field: {
    base: 'backgroundBaseWarning',
    active: 'backgroundLightWarning',
    text: 'textWarning'
  },
  value: {
    base: 'backgroundBaseSuccess',
    active: 'backgroundLightSuccess',
    text: 'textSuccess'
  },
  operator: {
    base: 'backgroundBasePrimary',
    active: 'backgroundLightPrimary',
    text: 'textPrimary'
  },
  conjunction: {
    base: 'backgroundBaseSubdued',
    active: 'backgroundLightText',
    text: 'textSubdued'
  },
  recentSearch: {
    base: 'backgroundBaseSubdued',
    active: 'backgroundLightText',
    text: 'textSubdued'
  }
};
const activeColors = context => Object.entries(kbnTypeaheadTypes).map(([type, color]) => {
  return {
    [`.kbnSuggestionItem--${type}`]: {
      '.kbnSuggestionItem__type': {
        backgroundColor: context.euiTheme.colors[color.active]
      }
    }
  };
});
const tokenColors = context => Object.entries(kbnTypeaheadTypes).map(([type, color]) => {
  return {
    [`&.kbnSuggestionItem--${type}`]: {
      '.kbnSuggestionItem__type': {
        backgroundColor: context.euiTheme.colors[color.base],
        color: context.euiTheme.colors[color.text]
      }
    }
  };
});
const suggestionStyles = {
  suggestionItem: context => (0, _react2.css)({
    '&.kbnTypeahead__item': {
      height: context.euiTheme.size.xl,
      whiteSpace: 'nowrap',
      fontSize: (0, _eui.euiFontSize)(context, 'xs').fontSize,
      verticalAlign: 'middle',
      padding: 0,
      borderBottom: 'none',
      lineHeight: 'normal',
      '&:hover': {
        cursor: 'pointer'
      },
      '&:last-child': {
        borderBottom: 'none',
        borderRadius: `0 0 ${context.euiTheme.border.radius.medium} ${context.euiTheme.border.radius.medium}`
      },
      '&:first-child': {
        borderBottom: 'none'
      },
      '&.active': (0, _react2.css)([{
        backgroundColor: context.euiTheme.colors.lightestShade,
        '.kbnSuggestionItem__callout': {
          background: context.euiTheme.colors.emptyShade
        },
        '.kbnSuggestionItem__text': {
          color: context.euiTheme.colors.fullShade
        },
        '.kbnSuggestionItem__type': {
          color: context.euiTheme.colors.fullShade
        }
      }, activeColors(context)])
    },
    '.kbnSuggestionItem': (0, _react2.css)([tokenColors(context), {
      display: 'inline-flex',
      alignItems: 'center',
      fontSize: (0, _eui.euiFontSize)(context, 'xs').fontSize,
      whiteSpace: 'nowrap',
      width: '100%'
    }]),
    '.kbnSuggestionItem__type': {
      display: 'flex',
      flexDirection: 'column',
      flexGrow: 0,
      flexShrink: 0,
      flexBasis: 'auto',
      width: context.euiTheme.size.xl,
      height: context.euiTheme.size.xl,
      textAlign: 'center',
      overflow: 'hidden',
      justifyContent: 'center',
      alignItems: 'center',
      padding: context.euiTheme.size.xs
    },
    '.kbnSuggestionItem__text': {
      fontFamily: context.euiTheme.font.familyCode,
      overflow: 'hidden',
      textOverflow: 'ellipsis',
      paddingLeft: context.euiTheme.size.s,
      color: context.euiTheme.colors.text,
      minWidth: '250px'
    },
    '.kbnSuggestionItem__description': {
      color: context.euiTheme.colors.darkShade,
      overflow: 'hidden',
      textOverflow: 'ellipsis',
      flexShrink: 1,
      // In case the description contains a paragraph in which the truncation needs to be at this level
      '> p': {
        overflow: 'hidden',
        textOverflow: 'ellipsis'
      },
      '&:empty': {
        width: 0
      }
    },
    '.kbnSuggestionItem__callout': {
      fontFamily: context.euiTheme.font.familyCode,
      background: context.euiTheme.colors.lightestShade,
      color: context.euiTheme.colors.fullShade,
      padding: `0 ${context.euiTheme.size.xs}`,
      display: 'inline-block'
    }
  })
};